/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.node.NodeInfo;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.server.NodeStatus;
import com.facebook.presto.server.ServerConfig;
import com.sun.management.OperatingSystemMXBean;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Objects;

@Path(value="/v1/status")
@RolesAllowed(value={"internal"})
public class StatusResource {
    private final NodeInfo nodeInfo;
    private final NodeVersion version;
    private final String environment;
    private final boolean coordinator;
    private final long startTime = System.nanoTime();
    private final int logicalCores;
    private final LocalMemoryManager memoryManager;
    private final MemoryMXBean memoryMXBean;
    private OperatingSystemMXBean operatingSystemMXBean;

    @Inject
    public StatusResource(NodeVersion nodeVersion, NodeInfo nodeInfo, ServerConfig serverConfig, LocalMemoryManager memoryManager) {
        this.nodeInfo = Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.coordinator = Objects.requireNonNull(serverConfig, "serverConfig is null").isCoordinator();
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
        this.logicalCores = Runtime.getRuntime().availableProcessors();
        if (ManagementFactory.getOperatingSystemMXBean() instanceof OperatingSystemMXBean) {
            this.operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        }
    }

    @HEAD
    @Produces(value={"application/json"})
    public Response statusPing() {
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    public NodeStatus getStatus() {
        return new NodeStatus(this.nodeInfo.getNodeId(), this.version, this.environment, this.coordinator, Duration.nanosSince((long)this.startTime), this.nodeInfo.getExternalAddress(), this.nodeInfo.getInternalAddress(), this.memoryManager.getInfo(), this.logicalCores, this.operatingSystemMXBean == null ? 0.0 : this.operatingSystemMXBean.getProcessCpuLoad(), this.operatingSystemMXBean == null ? 0.0 : this.operatingSystemMXBean.getSystemCpuLoad(), this.memoryMXBean.getHeapMemoryUsage().getUsed(), this.memoryMXBean.getHeapMemoryUsage().getMax(), this.memoryMXBean.getNonHeapMemoryUsage().getUsed());
    }
}

