/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StageId;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Objects;

@Path(value="/v1/stage")
@RolesAllowed(value={"user"})
public class StageResource {
    private final QueryManager queryManager;

    @Inject
    public StageResource(QueryManager queryManager) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
    }

    @DELETE
    @Path(value="{stageId}")
    public void cancelStage(@PathParam(value="stageId") StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        this.queryManager.cancelStage(stageId);
    }
}

