/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.facebook.presto.spi.page.SerializedPage;
import com.google.common.base.Preconditions;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import sun.misc.Unsafe;

public class SerializedPageWriteListener
implements WriteListener {
    private static final Logger log = Logger.get(SerializedPageWriteListener.class);
    private final ArrayDeque<SerializedPage> serializedPages;
    private final AsyncContext asyncContext;
    private final ServletOutputStream output;
    private final SliceOutput pageMetadataSliceOutput;
    private SerializedPage page;

    public SerializedPageWriteListener(List<SerializedPage> serializedPages, AsyncContext asyncContext, ServletOutputStream output) {
        this.serializedPages = new ArrayDeque(Objects.requireNonNull(serializedPages, "serializedPages is null"));
        this.asyncContext = Objects.requireNonNull(asyncContext, "asyncContext is null");
        this.output = Objects.requireNonNull(output, "output is null");
        this.pageMetadataSliceOutput = Slices.allocate((int)21).getOutput();
    }

    public void onWritePossible() throws IOException {
        while (this.output.isReady()) {
            if (this.writeComplete()) {
                this.asyncContext.complete();
                return;
            }
            if (this.page == null) {
                this.page = this.serializedPages.poll();
                this.pageMetadataSliceOutput.reset();
                PagesSerdeUtil.writeSerializedPageMetadata((SliceOutput)this.pageMetadataSliceOutput, (SerializedPage)this.page);
                this.output.write(this.pageMetadataSliceOutput.getUnderlyingSlice().byteArray(), 0, this.pageMetadataSliceOutput.size());
                continue;
            }
            Object base = this.page.getSlice().getBase();
            Preconditions.checkArgument((boolean)(base instanceof byte[]), (Object)"serialization type only supports byte[]");
            this.output.write((byte[])base, (int)(this.page.getSlice().getAddress() - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), this.page.getSizeInBytes());
            this.page = null;
        }
    }

    public void onError(Throwable t) {
        log.error(t);
        this.asyncContext.complete();
    }

    private boolean writeComplete() {
        return this.serializedPages.isEmpty() && this.page == null;
    }
}

