/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.server.RetryConfig;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class RetryUrlValidator {
    private static final Logger log = Logger.get(RetryUrlValidator.class);
    public static final String RETRY_PATH = "/v1/statement/queued/retry";
    private final RetryConfig retryConfig;

    @Inject
    public RetryUrlValidator(RetryConfig retryConfig) {
        this.retryConfig = Objects.requireNonNull(retryConfig, "retryConfig is null");
    }

    public boolean isValidRetryUrl(URI retryUrl, String currentServerHost) {
        Objects.requireNonNull(retryUrl, "retryUrl is null");
        if (!this.retryConfig.isRetryEnabled()) {
            return false;
        }
        try {
            if (this.retryConfig.isRequireHttps() && !"https".equalsIgnoreCase(retryUrl.getScheme())) {
                log.debug("Retry URL rejected - not HTTPS: %s", new Object[]{retryUrl});
                return false;
            }
            if (!retryUrl.getPath().startsWith(RETRY_PATH)) {
                log.debug("Retry URL rejected - invalid path: %s", new Object[]{retryUrl});
                return false;
            }
            if (retryUrl.getRawQuery() != null) {
                log.debug("Retry URL rejected - parameters present: %s", new Object[]{retryUrl});
                return false;
            }
            if (!this.isDomainAllowed(retryUrl.getHost(), currentServerHost)) {
                log.debug("Retry URL rejected - domain not allowed: %s", new Object[]{retryUrl.getHost()});
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.debug((Throwable)e, "Invalid retry URL: %s", new Object[]{retryUrl});
            return false;
        }
    }

    private boolean isDomainAllowed(String host, String currentServerHost) {
        Set allowedDomains = this.retryConfig.getAllowedRetryDomains();
        String lowerHost = host.toLowerCase(Locale.ENGLISH);
        if (allowedDomains.isEmpty()) {
            if (currentServerHost == null) {
                log.warn("Current server host not provided, cannot restrict to same domain");
                return false;
            }
            return lowerHost.equals(currentServerHost.toLowerCase(Locale.ENGLISH));
        }
        for (String allowedDomain : allowedDomains) {
            String suffix;
            if (!(allowedDomain.startsWith("*.") ? lowerHost.endsWith(suffix = allowedDomain.substring(1)) : lowerHost.equals(allowedDomain))) continue;
            return true;
        }
        return false;
    }
}

