/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.units.Duration;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@Path(value="/v1/resourceGroupState")
@RolesAllowed(value={"admin"})
public class ResourceGroupStateInfoResource {
    private final ResourceGroupManager<?> resourceGroupManager;
    private final boolean resourceManagerEnabled;
    private final InternalNodeManager internalNodeManager;
    private final Optional<ResourceManagerProxy> proxyHelper;
    private final Map<ResourceGroupStateInfoKey, Supplier<ResourceGroupInfo>> resourceGroupStateInfoKeySupplierMap;
    private final Supplier<List<ResourceGroupInfo>> rootResourceGroupInfoSupplier;
    private final Duration expirationDuration;

    @Inject
    public ResourceGroupStateInfoResource(ServerConfig serverConfig, ResourceGroupManager<?> resourceGroupManager, InternalNodeManager internalNodeManager, Optional<ResourceManagerProxy> proxyHelper) {
        this.resourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
        this.resourceGroupStateInfoKeySupplierMap = new HashMap<ResourceGroupStateInfoKey, Supplier<ResourceGroupInfo>>();
        this.expirationDuration = Objects.requireNonNull(serverConfig, "serverConfig is null").getClusterResourceGroupStateInfoExpirationDuration();
        this.rootResourceGroupInfoSupplier = this.expirationDuration.getValue() > 0.0 ? Suppliers.memoizeWithExpiration(() -> resourceGroupManager.getRootResourceGroups(), (long)this.expirationDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : () -> resourceGroupManager.getRootResourceGroups();
    }

    @GET
    @Produces(value={"application/json"})
    @Encoded
    @Path(value="{resourceGroupId: .*}")
    public void getResourceGroupInfos(@PathParam(value="resourceGroupId") String resourceGroupIdString, @QueryParam(value="includeQueryInfo") @DefaultValue(value="true") boolean includeQueryInfo, @QueryParam(value="includeLocalInfoOnly") @DefaultValue(value="false") boolean includeLocalInfoOnly, @QueryParam(value="summarizeSubgroups") @DefaultValue(value="true") boolean summarizeSubgroups, @QueryParam(value="includeStaticSubgroupsOnly") @DefaultValue(value="false") boolean includeStaticSubgroupsOnly, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (this.resourceManagerEnabled && !includeLocalInfoOnly) {
            this.proxyResourceGroupInfoResponse(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        try {
            if (Strings.isNullOrEmpty((String)resourceGroupIdString)) {
                asyncResponse.resume((Object)Response.ok().entity(this.rootResourceGroupInfoSupplier.get()).build());
            } else {
                ResourceGroupId resourceGroupId = this.getResourceGroupId(resourceGroupIdString);
                ResourceGroupStateInfoKey resourceGroupStateInfoKey = new ResourceGroupStateInfoKey(resourceGroupId, includeQueryInfo, summarizeSubgroups, includeStaticSubgroupsOnly);
                Supplier<ResourceGroupInfo> resourceGroupInfoSupplier = this.resourceGroupStateInfoKeySupplierMap.getOrDefault(resourceGroupStateInfoKey, (Supplier<ResourceGroupInfo>)(this.expirationDuration.getValue() > 0.0 ? Suppliers.memoizeWithExpiration(() -> this.getResourceGroupInfo(resourceGroupId, includeQueryInfo, summarizeSubgroups, includeStaticSubgroupsOnly), (long)this.expirationDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : () -> this.getResourceGroupInfo(resourceGroupId, includeQueryInfo, summarizeSubgroups, includeStaticSubgroupsOnly)));
                this.resourceGroupStateInfoKeySupplierMap.putIfAbsent(resourceGroupStateInfoKey, resourceGroupInfoSupplier);
                asyncResponse.resume((Object)Response.ok().entity(resourceGroupInfoSupplier.get()).build());
            }
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
    }

    private ResourceGroupInfo getResourceGroupInfo(ResourceGroupId resourceGroupId, boolean includeQueryInfo, boolean summarizeSubgroups, boolean includeStaticSubgroupsOnly) {
        return this.resourceGroupManager.getResourceGroupInfo(resourceGroupId, includeQueryInfo, summarizeSubgroups, includeStaticSubgroupsOnly);
    }

    private ResourceGroupId getResourceGroupId(String resourceGroupIdString) {
        return new ResourceGroupId((List)Arrays.stream(resourceGroupIdString.split("/")).map(ResourceGroupStateInfoResource::urlDecode).collect(ImmutableList.toImmutableList()));
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    private void proxyResourceGroupInfoResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, String xForwardedProto, UriInfo uriInfo) {
        try {
            Preconditions.checkState((boolean)this.proxyHelper.isPresent());
            Iterator resourceManagers = this.internalNodeManager.getResourceManagers().iterator();
            if (!resourceManagers.hasNext()) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                return;
            }
            InternalNode resourceManagerNode = (InternalNode)resourceManagers.next();
            URI uri = uriInfo.getRequestUriBuilder().scheme(resourceManagerNode.getInternalUri().getScheme()).host(resourceManagerNode.getHostAndPort().toInetAddress().getHostName()).port(resourceManagerNode.getInternalUri().getPort()).build(new Object[0]);
            this.proxyHelper.get().performRequest(servletRequest, asyncResponse, uri);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
        }
    }

    private static class ResourceGroupStateInfoKey {
        private final ResourceGroupId resourceGroupId;
        private final boolean includeQueryInfo;
        private final boolean summarizeSubGroups;
        private final boolean includeStaticSubgroupsOnly;

        public ResourceGroupStateInfoKey(ResourceGroupId resourceGroupId, boolean includeQueryInfo, boolean summarizeSubGroups, boolean includeStaticSubgroupsOnly) {
            this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
            this.includeQueryInfo = includeQueryInfo;
            this.summarizeSubGroups = summarizeSubGroups;
            this.includeStaticSubgroupsOnly = includeStaticSubgroupsOnly;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceGroupStateInfoKey that = (ResourceGroupStateInfoKey)o;
            return Objects.equals(that.resourceGroupId, this.resourceGroupId) && that.includeQueryInfo == this.includeQueryInfo && that.summarizeSubGroups == this.summarizeSubGroups && that.includeStaticSubgroupsOnly == this.includeStaticSubgroupsOnly;
        }

        public int hashCode() {
            return Objects.hash(this.resourceGroupId, this.includeQueryInfo, this.summarizeSubGroups, this.includeStaticSubgroupsOnly);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("resourceGroupId", (Object)this.resourceGroupId).add("includeQueryInfo", this.includeQueryInfo).add("summarizeSubGroups", this.summarizeSubGroups).add("includeStaticSubgroupsOnly", this.includeStaticSubgroupsOnly).toString();
        }
    }
}

