/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.QueryId;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.re2j.Pattern;
import io.airlift.slice.Slices;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

@Path(value="/v1/queryState")
@RolesAllowed(value={"admin", "user"})
public class QueryStateInfoResource {
    private final DispatchManager dispatchManager;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final boolean resourceManagerEnabled;
    private final InternalNodeManager internalNodeManager;
    private final Optional<ResourceManagerProxy> proxyHelper;

    @Inject
    public QueryStateInfoResource(DispatchManager dispatchManager, ResourceGroupManager<?> resourceGroupManager, InternalNodeManager internalNodeManager, ServerConfig serverConfig, Optional<ResourceManagerProxy> proxyHelper) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.resourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    @Produces(value={"application/json"})
    public void getQueryStateInfos(@QueryParam(value="user") String user, @QueryParam(value="includeLocalQueryOnly") @DefaultValue(value="false") boolean includeLocalQueryOnly, @QueryParam(value="includeAllQueries") @DefaultValue(value="false") boolean includeAllQueries, @QueryParam(value="includeAllQueryProgressStats") @DefaultValue(value="false") boolean includeAllQueryProgressStats, @QueryParam(value="excludeResourceGroupPathInfo") @DefaultValue(value="false") boolean excludeResourceGroupPathInfo, @QueryParam(value="queryTextSizeLimit") Integer queryTextSizeLimit, @QueryParam(value="state") String stateFilter, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        if (this.resourceManagerEnabled && !includeLocalQueryOnly) {
            this.proxyQueryStateInfo(servletRequest, asyncResponse, xForwardedProto, uriInfo);
        } else {
            List queryInfos = this.dispatchManager.getQueries();
            Optional userPattern = Strings.isNullOrEmpty((String)user) ? Optional.empty() : Optional.of(Pattern.compile((String)user));
            QueryState expectedQueryState = Optional.ofNullable(stateFilter).map(filter -> {
                try {
                    return QueryState.valueOf((String)filter.toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid 'state' parameter. Must be one of %s", Arrays.toString(QueryState.values()))).build());
                }
            }).orElse(null);
            List queryStateInfos = (List)queryInfos.stream().filter(queryInfo -> {
                boolean includeQuery = includeAllQueries || (expectedQueryState == null ? !queryInfo.getState().isDone() : queryInfo.getState().equals((Object)expectedQueryState));
                return includeQuery;
            }).filter(queryInfo -> userPattern.map(pattern -> pattern.matcher(Slices.utf8Slice((String)queryInfo.getSession().getUser())).matches()).orElse(true)).map(queryInfo -> this.getQueryStateInfo((BasicQueryInfo)queryInfo, includeAllQueryProgressStats, excludeResourceGroupPathInfo, queryTextSizeLimit == null ? OptionalInt.empty() : OptionalInt.of(queryTextSizeLimit))).collect(ImmutableList.toImmutableList());
            asyncResponse.resume((Object)Response.ok((Object)queryStateInfos).build());
        }
    }

    private QueryStateInfo getQueryStateInfo(BasicQueryInfo queryInfo, boolean includeAllQueryProgressStats, boolean excludeResourceGroupPathInfo, OptionalInt queryTextSizeLimit) {
        Optional groupId = queryInfo.getResourceGroupId();
        return QueryStateInfo.createQueryStateInfo((BasicQueryInfo)queryInfo, queryInfo.getState() == QueryState.QUEUED && !excludeResourceGroupPathInfo ? groupId.map(arg_0 -> this.resourceGroupManager.getPathToRoot(arg_0)) : Optional.empty(), (boolean)includeAllQueryProgressStats, (OptionalInt)queryTextSizeLimit);
    }

    @GET
    @Path(value="{queryId}")
    @Produces(value={"application/json"})
    public void getQueryStateInfo(@PathParam(value="queryId") String queryId, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) throws WebApplicationException {
        try {
            QueryId queryID = new QueryId(queryId);
            if (this.resourceManagerEnabled && !this.dispatchManager.isQueryPresent(queryID)) {
                this.proxyQueryStateInfo(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            } else {
                BasicQueryInfo queryInfo = this.dispatchManager.getQueryInfo(queryID);
                asyncResponse.resume((Object)Response.ok((Object)this.getQueryStateInfo(queryInfo, false, true, OptionalInt.empty())).build());
            }
        }
        catch (NoSuchElementException e) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
    }

    private void proxyQueryStateInfo(HttpServletRequest servletRequest, AsyncResponse asyncResponse, String xForwardedProto, UriInfo uriInfo) {
        try {
            Preconditions.checkState((boolean)this.proxyHelper.isPresent());
            Iterator resourceManagers = this.internalNodeManager.getResourceManagers().iterator();
            if (!resourceManagers.hasNext()) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                return;
            }
            InternalNode resourceManagerNode = (InternalNode)resourceManagers.next();
            URI uri = uriInfo.getRequestUriBuilder().scheme(resourceManagerNode.getInternalUri().getScheme()).host(resourceManagerNode.getHostAndPort().toInetAddress().getHostName()).port(resourceManagerNode.getInternalUri().getPort()).build(new Object[0]);
            this.proxyHelper.get().performRequest(servletRequest, asyncResponse, uri);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
        }
    }
}

