/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.failureDetector.HeartbeatFailureDetector;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;

@Path(value="/v1/node")
@RolesAllowed(value={"internal"})
public class NodeResource {
    private final HeartbeatFailureDetector failureDetector;

    @Inject
    public NodeResource(HeartbeatFailureDetector failureDetector) {
        this.failureDetector = failureDetector;
    }

    @GET
    public Collection<HeartbeatFailureDetector.Stats> getNodeStats() {
        return this.failureDetector.getStats().values();
    }

    @GET
    @Path(value="failed")
    public Collection<HeartbeatFailureDetector.Stats> getFailed() {
        return Maps.filterKeys(this.failureDetector.getStats(), (Predicate)Predicates.in(this.failureDetector.getFailed())).values();
    }
}

