/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.airlift.http.client.HttpClientConfig;
import com.facebook.airlift.http.client.spnego.KerberosConfig;
import com.facebook.airlift.jaxrs.JaxrsBinder;
import com.facebook.presto.server.InternalAuthenticationManager;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.facebook.presto.server.remotetask.ReactorNettyHttpClientConfig;
import com.facebook.presto.server.security.InternalAuthenticationFilter;
import com.google.common.base.Verify;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public class InternalCommunicationModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        InternalCommunicationConfig internalCommunicationConfig = (InternalCommunicationConfig)this.buildConfigObject(InternalCommunicationConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(HttpClientConfig.class, config -> {
            config.setKeyStorePath(internalCommunicationConfig.getKeyStorePath());
            config.setKeyStorePassword(internalCommunicationConfig.getKeyStorePassword());
            config.setTrustStorePath(internalCommunicationConfig.getTrustStorePath());
            config.setTrustStorePassword(internalCommunicationConfig.getTrustStorePassword());
            if (internalCommunicationConfig.getIncludedCipherSuites().isPresent()) {
                config.setHttpsIncludedCipherSuites((String)internalCommunicationConfig.getIncludedCipherSuites().get());
            }
            if (internalCommunicationConfig.getExcludeCipherSuites().isPresent()) {
                config.setHttpsExcludedCipherSuites((String)internalCommunicationConfig.getExcludeCipherSuites().get());
            }
        });
        ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(ReactorNettyHttpClientConfig.class, config -> {
            config.setHttpsEnabled(internalCommunicationConfig.isHttpsRequired());
            config.setKeyStorePath(internalCommunicationConfig.getKeyStorePath());
            config.setKeyStorePassword(internalCommunicationConfig.getKeyStorePassword());
            config.setTrustStorePath(internalCommunicationConfig.getTrustStorePath());
            if (internalCommunicationConfig.getIncludedCipherSuites().isPresent()) {
                config.setCipherSuites((String)internalCommunicationConfig.getIncludedCipherSuites().get());
            }
        });
        this.install(ConditionalModule.installModuleIf(InternalCommunicationConfig.class, InternalCommunicationConfig::isKerberosEnabled, (Module)this.kerberosInternalCommunicationModule()));
        binder.bind(InternalAuthenticationManager.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindGlobalFilter(InternalAuthenticationManager.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(InternalAuthenticationFilter.class);
    }

    private Module kerberosInternalCommunicationModule() {
        return binder -> {
            InternalCommunicationConfig clientKerberosConfig = (InternalCommunicationConfig)this.buildConfigObject(InternalCommunicationConfig.class);
            com.facebook.airlift.http.server.KerberosConfig serverKerberosConfig = (com.facebook.airlift.http.server.KerberosConfig)this.buildConfigObject(com.facebook.airlift.http.server.KerberosConfig.class);
            Verify.verify((serverKerberosConfig.getKeytab() != null ? 1 : 0) != 0, (String)"%s must be set when %s is true", (Object)"http.server.authentication.krb5.keytab", (Object)"internal-communication.kerberos.enabled");
            ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(KerberosConfig.class, kerberosConfig -> {
                kerberosConfig.setConfig(serverKerberosConfig.getKerberosConfig());
                kerberosConfig.setKeytab(serverKerberosConfig.getKeytab());
                kerberosConfig.setUseCanonicalHostname(clientKerberosConfig.isKerberosUseCanonicalHostname());
            });
            String kerberosPrincipal = serverKerberosConfig.getServiceName() + "/" + InternalCommunicationModule.getLocalCanonicalHostName();
            ConfigBinder.configBinder((Binder)binder).bindConfigGlobalDefaults(HttpClientConfig.class, httpClientConfig -> {
                httpClientConfig.setAuthenticationEnabled(true);
                httpClientConfig.setKerberosPrincipal(kerberosPrincipal);
                httpClientConfig.setKerberosRemoteServiceName(serverKerberosConfig.getServiceName());
            });
        };
    }

    private static String getLocalCanonicalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName().toLowerCase(Locale.US);
        }
        catch (UnknownHostException e) {
            throw new UncheckedIOException(e);
        }
    }
}

