/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.http.client.HttpRequestFilter;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.security.BasicPrincipal;
import com.facebook.presto.server.InternalCommunicationConfig;
import com.google.common.hash.Hashing;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class InternalAuthenticationManager
implements HttpRequestFilter {
    public static final String PRESTO_INTERNAL_BEARER = "X-Presto-Internal-Bearer";
    private static final Logger log = Logger.get(InternalAuthenticationManager.class);
    private final boolean internalJwtEnabled;
    private final byte[] hmac;
    private final String nodeId;

    @Inject
    public InternalAuthenticationManager(InternalCommunicationConfig internalCommunicationConfig, NodeInfo nodeInfo) {
        this(internalCommunicationConfig.getSharedSecret(), nodeInfo.getNodeId(), internalCommunicationConfig.isInternalJwtEnabled());
    }

    public InternalAuthenticationManager(Optional<String> sharedSecret, String nodeId, boolean internalJwtEnabled) {
        Objects.requireNonNull(sharedSecret, "sharedSecret is null");
        Objects.requireNonNull(nodeId, "nodeId is null");
        this.internalJwtEnabled = internalJwtEnabled;
        this.hmac = (byte[])(internalJwtEnabled ? Hashing.sha256().hashString((CharSequence)sharedSecret.get(), StandardCharsets.UTF_8).asBytes() : null);
        this.nodeId = nodeId;
    }

    public boolean isInternalJwtEnabled() {
        return this.internalJwtEnabled;
    }

    private String generateJwt() {
        return Jwts.builder().signWith(SignatureAlgorithm.HS256, this.hmac).setSubject(this.nodeId).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
    }

    private String parseJwt(String jwt) {
        return ((Claims)Jwts.parser().setSigningKey(this.hmac).parseClaimsJws(jwt).getBody()).getSubject();
    }

    public boolean isInternalRequest(ContainerRequestContext context) {
        return context.getHeaderString(PRESTO_INTERNAL_BEARER) != null;
    }

    public Principal authenticateInternalRequest(ContainerRequestContext context) {
        if (!this.internalJwtEnabled) {
            log.error("Internal authentication in not enabled");
            return null;
        }
        String internalBearer = context.getHeaderString(PRESTO_INTERNAL_BEARER);
        if (internalBearer == null) {
            log.error("Internal authentication failed");
            return null;
        }
        try {
            String subject = this.parseJwt(internalBearer);
            return new BasicPrincipal(subject);
        }
        catch (JwtException e) {
            log.error((Throwable)e, "Internal authentication failed");
            return null;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Authentication error", e);
        }
    }

    public Request filterRequest(Request request) {
        if (!this.internalJwtEnabled) {
            return request;
        }
        return Request.Builder.fromRequest((Request)request).addHeader(PRESTO_INTERNAL_BEARER, this.generateJwt()).build();
    }
}

