/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.units.DataSize;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.Session;
import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.security.ServletSecurityUtils;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.AuthorizedIdentity;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.session.ResourceEstimates;
import com.facebook.presto.spi.tracing.Tracer;
import com.facebook.presto.spi.tracing.TracerHandle;
import com.facebook.presto.spi.tracing.TracerProvider;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.tracing.NoopTracerProvider;
import com.facebook.presto.tracing.TracingConfig;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class HttpRequestSessionContext
implements SessionContext {
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    private static final JsonCodec<SqlFunctionId> SQL_FUNCTION_ID_JSON_CODEC = JsonCodec.jsonCodec(SqlFunctionId.class);
    private static final JsonCodec<SqlInvokedFunction> SQL_INVOKED_FUNCTION_JSON_CODEC = JsonCodec.jsonCodec(SqlInvokedFunction.class);
    private static final String X509_ATTRIBUTE = "jakarta.servlet.request.X509Certificate";
    private final String catalog;
    private final String schema;
    private final String sqlText;
    private final Identity identity;
    private final Optional<AuthorizedIdentity> authorizedIdentity;
    private final List<X509Certificate> certificates;
    private final String source;
    private final Optional<String> traceToken;
    private final String userAgent;
    private final String remoteUserAddress;
    private final String timeZoneId;
    private final String language;
    private final Set<String> clientTags;
    private final ResourceEstimates resourceEstimates;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogSessionProperties;
    private final Map<String, String> preparedStatements;
    private final Optional<TransactionId> transactionId;
    private final boolean clientTransactionSupport;
    private final String clientInfo;
    private final Map<SqlFunctionId, SqlInvokedFunction> sessionFunctions;
    private final Optional<SessionPropertyManager> sessionPropertyManager;
    private final Optional<Tracer> tracer;
    private final RuntimeStats runtimeStats = new RuntimeStats();

    public HttpRequestSessionContext(HttpServletRequest servletRequest, SqlParserOptions sqlParserOptions) {
        this(servletRequest, sqlParserOptions, (TracerProvider)NoopTracerProvider.NOOP_TRACER_PROVIDER, Optional.empty(), "");
    }

    public HttpRequestSessionContext(HttpServletRequest servletRequest, SqlParserOptions sqlParserOptions, TracerProvider tracerProvider, Optional<SessionPropertyManager> sessionPropertyManager, String sqlText) throws WebApplicationException {
        this.catalog = HttpRequestSessionContext.trimEmptyToNull(servletRequest.getHeader("X-Presto-Catalog"));
        this.schema = HttpRequestSessionContext.trimEmptyToNull(servletRequest.getHeader("X-Presto-Schema"));
        this.sqlText = Objects.requireNonNull(sqlText, "sqlText is null");
        HttpRequestSessionContext.assertRequest(this.catalog != null || this.schema == null, "Schema is set but catalog is not", new Object[0]);
        String user = HttpRequestSessionContext.trimEmptyToNull(servletRequest.getHeader("X-Presto-User"));
        HttpRequestSessionContext.assertRequest(user != null, "User must be set", new Object[0]);
        this.authorizedIdentity = ServletSecurityUtils.authorizedIdentity(servletRequest);
        Object[] certs = (X509Certificate[])servletRequest.getAttribute(X509_ATTRIBUTE);
        this.certificates = certs != null && certs.length > 0 ? ImmutableList.copyOf((Object[])certs) : ImmutableList.of();
        this.identity = new Identity(user, Optional.ofNullable(servletRequest.getUserPrincipal()), HttpRequestSessionContext.parseRoleHeaders(servletRequest), HttpRequestSessionContext.parseExtraCredentials(servletRequest), (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), this.certificates);
        this.source = servletRequest.getHeader("X-Presto-Source");
        this.userAgent = servletRequest.getHeader("User-Agent");
        this.remoteUserAddress = !Strings.isNullOrEmpty((String)servletRequest.getHeader("X-Forwarded-For")) ? servletRequest.getHeader("X-Forwarded-For") : servletRequest.getRemoteAddr();
        this.timeZoneId = servletRequest.getHeader("X-Presto-Time-Zone");
        this.language = servletRequest.getHeader("X-Presto-Language");
        this.clientInfo = servletRequest.getHeader("X-Presto-Client-Info");
        this.clientTags = this.parseClientTags(servletRequest);
        this.resourceEstimates = HttpRequestSessionContext.parseResourceEstimate(servletRequest);
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        HashMap<String, Map> catalogSessionProperties = new HashMap<String, Map>();
        for (Map.Entry<String, String> entry2 : HttpRequestSessionContext.parseSessionHeaders(servletRequest).entrySet()) {
            String fullPropertyName = entry2.getKey();
            String propertyValue = entry2.getValue();
            List nameParts = DOT_SPLITTER.splitToList((CharSequence)fullPropertyName);
            if (nameParts.size() == 1) {
                String propertyName = (String)nameParts.get(0);
                HttpRequestSessionContext.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                systemProperties.put((Object)propertyName, (Object)propertyValue);
                continue;
            }
            if (nameParts.size() == 2) {
                String catalogName = (String)nameParts.get(0);
                String propertyName = (String)nameParts.get(1);
                HttpRequestSessionContext.assertRequest(!catalogName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                HttpRequestSessionContext.assertRequest(!propertyName.isEmpty(), "Invalid %s header", "X-Presto-Session");
                catalogSessionProperties.computeIfAbsent(catalogName, id -> new HashMap()).put(propertyName, propertyValue);
                continue;
            }
            throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header", "X-Presto-Session"));
        }
        this.systemProperties = systemProperties.build();
        this.catalogSessionProperties = (Map)catalogSessionProperties.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        this.preparedStatements = HttpRequestSessionContext.parsePreparedStatementsHeaders(servletRequest, sqlParserOptions);
        String transactionIdHeader = servletRequest.getHeader("X-Presto-Transaction-Id");
        this.clientTransactionSupport = transactionIdHeader != null;
        this.transactionId = HttpRequestSessionContext.parseTransactionId(transactionIdHeader);
        this.sessionFunctions = HttpRequestSessionContext.parseSessionFunctionHeader(servletRequest);
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        Map<String, String> requestHeaders = HttpRequestSessionContext.getRequestHeaders(servletRequest);
        TracerHandle tracerHandle = (TracerHandle)tracerProvider.getHandleGenerator().apply(requestHeaders);
        if (this.isTracingEnabled()) {
            this.tracer = Optional.of(Objects.requireNonNull(tracerProvider.getNewTracer(tracerHandle), "tracer is null"));
            this.traceToken = Optional.ofNullable(this.tracer.get().getTracerId());
        } else {
            this.tracer = Optional.of(NoopTracerProvider.NOOP_TRACER);
            String tunnelTraceId = HttpRequestSessionContext.trimEmptyToNull(servletRequest.getHeader("X-Presto-Trace-Token"));
            this.traceToken = tunnelTraceId != null ? Optional.of(tunnelTraceId) : Optional.ofNullable(tracerHandle.getTraceToken());
        }
    }

    private static Map<String, String> getRequestHeaders(HttpServletRequest servletRequest) {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        Enumeration headerNames = servletRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            headers.put((Object)header, (Object)servletRequest.getHeader(header));
        }
        return headers.build();
    }

    public static List<String> splitSessionHeader(Enumeration<String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)Collections.list(headers).stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private static Map<String, String> parseSessionHeaders(HttpServletRequest servletRequest) {
        return HttpRequestSessionContext.parseProperty(servletRequest, "X-Presto-Session");
    }

    private static Map<String, SelectedRole> parseRoleHeaders(HttpServletRequest servletRequest) {
        ImmutableMap.Builder roles = ImmutableMap.builder();
        for (String header : HttpRequestSessionContext.splitSessionHeader(servletRequest.getHeaders("X-Presto-Role"))) {
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Role");
            roles.put((Object)((String)nameValue.get(0)), (Object)SelectedRole.valueOf((String)HttpRequestSessionContext.urlDecode((String)nameValue.get(1))));
        }
        return roles.build();
    }

    private static Map<String, String> parseExtraCredentials(HttpServletRequest servletRequest) {
        return HttpRequestSessionContext.parseCredentialProperty(servletRequest, "X-Presto-Extra-Credential");
    }

    private static Map<String, String> parseProperty(HttpServletRequest servletRequest, String headerName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String header : HttpRequestSessionContext.splitSessionHeader(servletRequest.getHeaders(headerName))) {
            List nameValue = Splitter.on((char)'=').trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", headerName);
            properties.put((String)nameValue.get(0), HttpRequestSessionContext.urlDecode((String)nameValue.get(1)));
        }
        return properties;
    }

    private static Map<String, String> parseCredentialProperty(HttpServletRequest servletRequest, String headerName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String header : HttpRequestSessionContext.splitSessionHeader(servletRequest.getHeaders(headerName))) {
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", headerName);
            properties.put((String)nameValue.get(0), HttpRequestSessionContext.urlDecode((String)nameValue.get(1)));
        }
        return properties;
    }

    private static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw HttpRequestSessionContext.badRequest(String.format(format, args));
        }
    }

    private static Map<String, String> parsePreparedStatementsHeaders(HttpServletRequest servletRequest, SqlParserOptions sqlParserOptions) {
        ImmutableMap.Builder preparedStatements = ImmutableMap.builder();
        for (String header : HttpRequestSessionContext.splitSessionHeader(servletRequest.getHeaders("X-Presto-Prepared-Statement"))) {
            String sqlString;
            String statementName;
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Prepared-Statement");
            try {
                statementName = HttpRequestSessionContext.urlDecode((String)nameValue.get(0));
                sqlString = HttpRequestSessionContext.urlDecode((String)nameValue.get(1));
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            SqlParser sqlParser = new SqlParser(sqlParserOptions);
            try {
                sqlParser.createStatement(sqlString, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE));
            }
            catch (ParsingException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", "X-Presto-Prepared-Statement", e.getMessage()));
            }
            preparedStatements.put((Object)statementName, (Object)sqlString);
        }
        return preparedStatements.build();
    }

    private static Optional<TransactionId> parseTransactionId(String transactionId) {
        if ((transactionId = HttpRequestSessionContext.trimEmptyToNull(transactionId)) == null || transactionId.equalsIgnoreCase("none")) {
            return Optional.empty();
        }
        try {
            return Optional.of(TransactionId.valueOf((String)transactionId));
        }
        catch (Exception e) {
            throw HttpRequestSessionContext.badRequest(e.getMessage());
        }
    }

    private static Map<SqlFunctionId, SqlInvokedFunction> parseSessionFunctionHeader(HttpServletRequest req) {
        ImmutableMap.Builder sessionFunctions = ImmutableMap.builder();
        for (String header : HttpRequestSessionContext.splitSessionHeader(req.getHeaders("X-Presto-Session-Function"))) {
            String serializedFunctionDefinition;
            String serializedFunctionSignature;
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Session-Function");
            try {
                serializedFunctionSignature = HttpRequestSessionContext.urlDecode((String)nameValue.get(0));
                serializedFunctionDefinition = HttpRequestSessionContext.urlDecode((String)nameValue.get(1));
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Invalid %s header: %s", "X-Presto-Session-Function", e.getMessage()));
            }
            sessionFunctions.put((Object)((SqlFunctionId)SQL_FUNCTION_ID_JSON_CODEC.fromJson(serializedFunctionSignature)), (Object)((SqlInvokedFunction)SQL_INVOKED_FUNCTION_JSON_CODEC.fromJson(serializedFunctionDefinition)));
        }
        return sessionFunctions.build();
    }

    private static WebApplicationException badRequest(String message) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)message).build());
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public Optional<AuthorizedIdentity> getAuthorizedIdentity() {
        return this.authorizedIdentity;
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public String getSource() {
        return this.source;
    }

    public String getRemoteUserAddress() {
        return this.remoteUserAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public ResourceEstimates getResourceEstimates() {
        return this.resourceEstimates;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public String getLanguage() {
        return this.language;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, Map<String, String>> getCatalogSessionProperties() {
        return this.catalogSessionProperties;
    }

    public Map<String, String> getPreparedStatements() {
        return this.preparedStatements;
    }

    public Optional<TransactionId> getTransactionId() {
        return this.transactionId;
    }

    public boolean supportClientTransaction() {
        return this.clientTransactionSupport;
    }

    public Map<SqlFunctionId, SqlInvokedFunction> getSessionFunctions() {
        return this.sessionFunctions;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }

    public Optional<Tracer> getTracer() {
        return this.tracer;
    }

    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    private boolean isTracingEnabled() {
        String clientValue = this.systemProperties.getOrDefault("distributed_tracing_mode", "");
        if (clientValue.equalsIgnoreCase(TracingConfig.DistributedTracingMode.ALWAYS_TRACE.name())) {
            return true;
        }
        if (clientValue.equalsIgnoreCase(TracingConfig.DistributedTracingMode.NO_TRACE.name())) {
            return false;
        }
        if (clientValue.equalsIgnoreCase(TracingConfig.DistributedTracingMode.SAMPLE_BASED.name())) {
            return true;
        }
        return this.sessionPropertyManager.map(manager -> ((String)manager.decodeSystemPropertyValue("distributed_tracing_mode", null, String.class)).equalsIgnoreCase(TracingConfig.DistributedTracingMode.ALWAYS_TRACE.name())).orElse(false);
    }

    private Set<String> parseClientTags(HttpServletRequest servletRequest) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return ImmutableSet.copyOf((Iterable)splitter.split((CharSequence)Strings.nullToEmpty((String)servletRequest.getHeader("X-Presto-Client-Tags"))));
    }

    public static ResourceEstimates parseResourceEstimate(HttpServletRequest servletRequest) {
        Session.ResourceEstimateBuilder builder = new Session.ResourceEstimateBuilder();
        for (String header : HttpRequestSessionContext.splitSessionHeader(servletRequest.getHeaders("X-Presto-Resource-Estimate"))) {
            List nameValue = Splitter.on((char)'=').limit(2).trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContext.assertRequest(nameValue.size() == 2, "Invalid %s header", "X-Presto-Resource-Estimate");
            String name = (String)nameValue.get(0);
            String value = (String)nameValue.get(1);
            try {
                switch (name.toUpperCase()) {
                    case "EXECUTION_TIME": {
                        builder.setExecutionTime(Duration.valueOf((String)value));
                        break;
                    }
                    case "CPU_TIME": {
                        builder.setCpuTime(Duration.valueOf((String)value));
                        break;
                    }
                    case "PEAK_MEMORY": {
                        builder.setPeakMemory(DataSize.valueOf((String)value));
                        break;
                    }
                    case "PEAK_TASK_MEMORY": {
                        builder.setPeakTaskMemory(DataSize.valueOf((String)value));
                        break;
                    }
                    default: {
                        throw HttpRequestSessionContext.badRequest(String.format("Unsupported resource name %s", name));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw HttpRequestSessionContext.badRequest(String.format("Unsupported format for resource estimate '%s': %s", value, e));
            }
        }
        return builder.build();
    }
}

