/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.discovery.client.DiscoveryBinder;
import com.facebook.airlift.discovery.server.EmbeddedDiscoveryModule;
import com.facebook.drift.server.guice.DriftServerBinder;
import com.facebook.presto.catalogserver.CatalogServer;
import com.facebook.presto.dispatcher.NoOpQueryManager;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.resourceGroups.NoOpResourceGroupManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.failureDetector.FailureDetectorModule;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.server.EmbeddedDiscoveryConfig;
import com.facebook.presto.server.NodeResourceStatusProvider;
import com.facebook.presto.transaction.ForTransactionManager;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class CatalogServerModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install(ConditionalModule.installModuleIf(EmbeddedDiscoveryConfig.class, EmbeddedDiscoveryConfig::isEnabled, (Module)new EmbeddedDiscoveryModule()));
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto-catalog-server");
        binder.install((Module)new FailureDetectorModule());
        binder.bind(QueryManager.class).to(NoOpQueryManager.class).in(Scopes.SINGLETON);
        binder.bind(ResourceGroupManager.class).to(NoOpResourceGroupManager.class);
        DriftServerBinder.driftServerBinder((Binder)binder).bindService(CatalogServer.class);
        binder.bind(NodeResourceStatusProvider.class).toInstance(() -> true);
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, CatalogManager catalogManager, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return InMemoryTransactionManager.create((TransactionManagerConfig)config, (ScheduledExecutorService)idleCheckExecutor, (CatalogManager)catalogManager, (ExecutorService)finishingExecutor);
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }
}

