/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.presto.execution.TaskId;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

@Path(value="/v1/taskInfo")
@RolesAllowed(value={"user", "admin"})
public class DistributedTaskInfoResource {
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final ResourceManagerProxy proxyHelper;

    @Inject
    public DistributedTaskInfoResource(ResourceManagerClusterStateProvider clusterStateProvider, ResourceManagerProxy proxyHelper) {
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "clusterStateProvider is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    @Path(value="{taskId}")
    public void getTaskInfo(@PathParam(value="taskId") TaskId taskId, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) throws WebApplicationException {
        this.proxyTaskInfoResponse(servletRequest, asyncResponse, uriInfo, taskId);
    }

    private URI createTaskInfoUri(BasicQueryInfo queryInfo, UriInfo uriInfo) {
        return UriBuilder.fromUri((URI)queryInfo.getSelf()).replacePath(uriInfo.getPath()).build(new Object[0]);
    }

    private void proxyTaskInfoResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, UriInfo uriInfo, TaskId taskId) {
        QueryId queryId = taskId.getQueryId();
        Optional<BasicQueryInfo> queryInfo = this.clusterStateProvider.getClusterQueries().stream().filter(query -> query.getQueryId().equals((Object)queryId)).findFirst();
        if (queryInfo.isPresent()) {
            this.proxyHelper.performRequest(servletRequest, asyncResponse, this.createTaskInfoUri(queryInfo.get(), uriInfo));
        } else {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").build());
        }
    }
}

