/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

@Path(value="/v1/query")
@RolesAllowed(value={"user", "admin"})
public class DistributedQueryResource {
    private static final Comparator<BasicQueryInfo> QUERIES_ORDERING = Ordering.from((o2, o1) -> Boolean.compare(o1.getState() == QueryState.RUNNING, o2.getState() == QueryState.RUNNING)).compound((o1, o2) -> Boolean.compare(o1.getState() == QueryState.QUEUED, o2.getState() == QueryState.QUEUED)).compound((o1, o2) -> Boolean.compare(!o1.getState().isDone(), !o2.getState().isDone())).compound((o1, o2) -> Boolean.compare(o1.getState() == QueryState.FAILED, o2.getState() == QueryState.FAILED)).compound(Comparator.comparing(item -> item.getQueryStats().getCreateTime()));
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final ResourceManagerProxy proxyHelper;

    @Inject
    public DistributedQueryResource(ResourceManagerClusterStateProvider clusterStateProvider, ResourceManagerProxy proxyHelper) {
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "nodeStateManager is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
    }

    @GET
    public Response getAllQueryInfo(@QueryParam(value="state") String stateFilter, @QueryParam(value="limit") Integer limitFilter) {
        ImmutableList queries;
        QueryState expectedState = stateFilter == null ? null : QueryState.valueOf((String)stateFilter.toUpperCase(Locale.ENGLISH));
        int limit = (Integer)MoreObjects.firstNonNull((Object)limitFilter, (Object)Integer.MAX_VALUE);
        if (limit <= 0) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Parameter 'limit' for getAllQueryInfo must be positive. Got %d.", limit)).build());
        }
        if (stateFilter == null) {
            queries = this.clusterStateProvider.getClusterQueries();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BasicQueryInfo queryInfo : this.clusterStateProvider.getClusterQueries()) {
                if (queryInfo.getState() != expectedState) continue;
                builder.add((Object)queryInfo);
            }
            queries = builder.build();
        }
        queries = new ArrayList(queries);
        if (limit < queries.size()) {
            queries.sort(QUERIES_ORDERING);
        } else {
            limit = queries.size();
        }
        queries = ImmutableList.copyOf(queries.subList(0, limit));
        return Response.ok((Object)queries).build();
    }

    @GET
    @Path(value="{queryId}")
    public void getQueryInfo(@PathParam(value="queryId") QueryId queryId, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    @DELETE
    @Path(value="{queryId}")
    public void cancelQuery(@PathParam(value="queryId") QueryId queryId, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    @PUT
    @Path(value="{queryId}/killed")
    public void killQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    @PUT
    @Path(value="{queryId}/preempted")
    public void preemptQuery(@PathParam(value="queryId") QueryId queryId, String message, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) {
        this.proxyResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    private void proxyResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, UriInfo uriInfo, QueryId queryId) {
        Optional<BasicQueryInfo> queryInfo = this.clusterStateProvider.getClusterQueries().stream().filter(query -> query.getQueryId().equals((Object)queryId)).findFirst();
        if (!queryInfo.isPresent()) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.APPLICATION_JSON_TYPE).build());
            return;
        }
        this.proxyHelper.performRequest(servletRequest, asyncResponse, HttpUriBuilder.uriBuilderFrom((URI)queryInfo.get().getSelf()).replacePath(uriInfo.getPath()).build());
    }
}

