/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.airlift.http.client.ResponseTooLargeException;
import com.facebook.airlift.http.client.StatusResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.units.DataSize;
import com.facebook.presto.PrestoMediaTypes;
import com.facebook.presto.operator.PageBufferClient;
import com.facebook.presto.operator.PageTooLargeException;
import com.facebook.presto.operator.PageTransportErrorException;
import com.facebook.presto.operator.RpcShuffleClient;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.page.PagesSerdeUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.slice.InputStreamSliceInput;
import io.airlift.slice.SliceInput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;

@ThreadSafe
public final class HttpRpcShuffleClient
implements RpcShuffleClient {
    private static final Logger log = Logger.get(HttpRpcShuffleClient.class);
    private final HttpClient httpClient;
    private final URI location;

    public HttpRpcShuffleClient(HttpClient httpClient, URI location) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.location = Objects.requireNonNull(location, "location is null");
    }

    public ListenableFuture<PageBufferClient.PagesResponse> getResults(long token, DataSize maxResponseSize) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.location).appendPath(String.valueOf(token)).build();
        return this.httpClient.executeAsync(Request.Builder.prepareGet().setHeader("X-Presto-Max-Size", maxResponseSize.toString()).setUri(uri).build(), (ResponseHandler)new PageResponseHandler());
    }

    public void acknowledgeResultsAsync(long nextToken) {
        final URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.location).appendPath(String.valueOf(nextToken)).appendPath("acknowledge").build();
        this.httpClient.executeAsync(Request.Builder.prepareGet().setUri(uri).build(), (ResponseHandler)new ResponseHandler<Void, RuntimeException>(){

            public Void handleException(Request request, Exception exception) {
                log.debug((Throwable)exception, "Acknowledge request failed: %s", new Object[]{uri});
                return null;
            }

            public Void handle(Request request, Response response) {
                if (HttpStatus.familyForStatusCode((int)response.getStatusCode()) != HttpStatus.Family.SUCCESSFUL) {
                    log.debug("Unexpected acknowledge response code: %s", new Object[]{response.getStatusCode()});
                }
                return null;
            }
        });
    }

    public ListenableFuture<?> abortResults() {
        return this.httpClient.executeAsync(Request.Builder.prepareDelete().setUri(this.location).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
    }

    public Throwable rewriteException(Throwable throwable) {
        if (throwable instanceof ResponseTooLargeException) {
            return new PageTooLargeException(throwable);
        }
        return throwable;
    }

    public static class PageResponseHandler
    implements ResponseHandler<PageBufferClient.PagesResponse, RuntimeException> {
        public PageBufferClient.PagesResponse handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public PageBufferClient.PagesResponse handle(Request request, Response response) {
            PageBufferClient.PagesResponse pagesResponse;
            if (response.getStatusCode() == HttpStatus.NO_CONTENT.code()) {
                return PageBufferClient.PagesResponse.createEmptyPagesResponse((String)PageResponseHandler.getTaskInstanceId(request, response), (long)PageResponseHandler.getToken(request, response), (long)PageResponseHandler.getNextToken(request, response), (boolean)PageResponseHandler.getComplete(request, response));
            }
            if (response.getStatusCode() != HttpStatus.OK.code()) {
                StringBuilder body = new StringBuilder();
                try (BufferedReader reader2 = new BufferedReader(new InputStreamReader(response.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    for (int i = 0; i < 1000 && (line = reader2.readLine()) != null; ++i) {
                        if (body.length() + line.length() > 102400) {
                            break;
                        }
                        body.append(line + "\n");
                    }
                }
                catch (IOException | RuntimeException reader2) {
                    // empty catch block
                }
                throw new PageTransportErrorException(HostAddress.fromUri((URI)request.getUri()), String.format("Expected response code to be 200, but was %s:%n%s", response.getStatusCode(), body.toString()));
            }
            String contentType = response.getHeader("Content-Type");
            if (contentType == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)request.getUri()), String.format("%s header is not set: %s", "Content-Type", response));
            }
            if (!PageResponseHandler.mediaTypeMatches(contentType, PrestoMediaTypes.PRESTO_PAGES_TYPE)) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)request.getUri()), String.format("Expected %s response from server but got %s", PrestoMediaTypes.PRESTO_PAGES_TYPE, contentType));
            }
            String taskInstanceId = PageResponseHandler.getTaskInstanceId(request, response);
            long token = PageResponseHandler.getToken(request, response);
            long nextToken = PageResponseHandler.getNextToken(request, response);
            boolean complete = PageResponseHandler.getComplete(request, response);
            InputStreamSliceInput input = new InputStreamSliceInput(response.getInputStream());
            try {
                ImmutableList pages = ImmutableList.copyOf((Iterator)PagesSerdeUtil.readSerializedPages((SliceInput)input));
                pagesResponse = PageBufferClient.PagesResponse.createPagesResponse((String)taskInstanceId, (long)token, (long)nextToken, (Iterable)pages, (boolean)complete);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (PageTransportErrorException e) {
                    throw new PageTransportErrorException(e.getRemoteHost(), "Error fetching " + request.getUri().toASCIIString(), (Throwable)e);
                }
            }
            input.close();
            return pagesResponse;
        }

        private static String getTaskInstanceId(Request request, Response response) {
            String taskInstanceId = response.getHeader("X-Presto-Task-Instance-Id");
            if (taskInstanceId == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)request.getUri()), String.format("Expected %s header", "X-Presto-Task-Instance-Id"));
            }
            return taskInstanceId;
        }

        private static long getToken(Request request, Response response) {
            String tokenHeader = response.getHeader("X-Presto-Page-Sequence-Id");
            if (tokenHeader == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)request.getUri()), String.format("Expected %s header", "X-Presto-Page-Sequence-Id"));
            }
            return Long.parseLong(tokenHeader);
        }

        private static long getNextToken(Request request, Response response) {
            String nextTokenHeader = response.getHeader("X-Presto-Page-End-Sequence-Id");
            if (nextTokenHeader == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)request.getUri()), String.format("Expected %s header", "X-Presto-Page-End-Sequence-Id"));
            }
            return Long.parseLong(nextTokenHeader);
        }

        private static boolean getComplete(Request request, Response response) {
            String bufferComplete = response.getHeader("X-Presto-Buffer-Complete");
            if (bufferComplete == null) {
                throw new PageTransportErrorException(HostAddress.fromUri((URI)request.getUri()), String.format("Expected %s header", "X-Presto-Buffer-Complete"));
            }
            return Boolean.parseBoolean(bufferComplete);
        }

        private static boolean mediaTypeMatches(String value, MediaType range) {
            try {
                return MediaType.parse((String)value).is(range);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                return false;
            }
        }
    }
}

