/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.ForExchange;
import com.facebook.presto.operator.HttpShuffleClientProvider;
import com.facebook.presto.operator.RpcShuffleClient;
import com.facebook.presto.operator.RpcShuffleClientProvider;
import com.facebook.presto.operator.ThriftShuffleClientProvider;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Locale;

public class HttpAndThriftRpcShuffleClientProvider
implements RpcShuffleClientProvider {
    private final HttpShuffleClientProvider httpShuffleClientProvider;
    private final ThriftShuffleClientProvider thriftShuffleClientProvider;

    @Inject
    public HttpAndThriftRpcShuffleClientProvider(@ForExchange HttpShuffleClientProvider httpShuffleClientProvider, @ForExchange ThriftShuffleClientProvider thriftShuffleClientProvider) {
        this.httpShuffleClientProvider = httpShuffleClientProvider;
        this.thriftShuffleClientProvider = thriftShuffleClientProvider;
    }

    public RpcShuffleClient get(URI location) {
        switch (location.getScheme().toLowerCase(Locale.getDefault())) {
            case "https": 
            case "http": {
                return this.httpShuffleClientProvider.get(location);
            }
            case "thrift": {
                return this.thriftShuffleClientProvider.get(location);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "unsupported task result client scheme " + location.getScheme());
    }
}

