/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.airlift.http.client.FullJsonResponseHandler;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.metadata.RemoteNodeStats;
import com.facebook.presto.spi.NodeStats;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class HttpRemoteNodeStats
implements RemoteNodeStats {
    private static final Logger log = Logger.get(HttpRemoteNodeStats.class);
    private final HttpClient httpClient;
    private final URI stateInfoUri;
    private final long refreshIntervalMillis;
    private final AtomicReference<Optional<NodeStats>> nodeStats = new AtomicReference(Optional.empty());
    private final AtomicReference<Future<?>> future = new AtomicReference();
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final AtomicLong lastWarningLogged = new AtomicLong();

    public HttpRemoteNodeStats(HttpClient httpClient, URI stateInfoUri, long refreshIntervalMillis) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.stateInfoUri = Objects.requireNonNull(stateInfoUri, "stateInfoUri is null");
        this.refreshIntervalMillis = refreshIntervalMillis;
    }

    public Optional<NodeStats> getNodeStats() {
        return this.nodeStats.get();
    }

    public synchronized void asyncRefresh() {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (Duration.nanosSince((long)this.lastWarningLogged.get()).toMillis() > 1000L && sinceUpdate.toMillis() > 10000L && this.future.get() != null) {
            log.warn("Node state update request to %s has not returned in %s", new Object[]{this.stateInfoUri, sinceUpdate.toString(TimeUnit.SECONDS)});
            this.lastWarningLogged.set(System.nanoTime());
        }
        if (sinceUpdate.toMillis() > this.refreshIntervalMillis && this.future.get() == null) {
            Request request = Request.Builder.prepareGet().setUri(this.stateInfoUri).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).build();
            final HttpClient.HttpResponseFuture responseFuture = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(NodeStats.class)));
            this.future.compareAndSet((Future<?>)null, (Future<?>)responseFuture);
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<FullJsonResponseHandler.JsonResponse<NodeStats>>(){

                public void onSuccess(@Nullable FullJsonResponseHandler.JsonResponse<NodeStats> result) {
                    HttpRemoteNodeStats.this.lastUpdateNanos.set(System.nanoTime());
                    HttpRemoteNodeStats.this.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                    if (result != null) {
                        if (result.hasValue()) {
                            HttpRemoteNodeStats.this.nodeStats.set(Optional.ofNullable((NodeStats)result.getValue()));
                        }
                        if (result.getStatusCode() != HttpStatus.OK.code()) {
                            log.warn("Error fetching node stats from %s returned status %d", new Object[]{HttpRemoteNodeStats.this.stateInfoUri, result.getStatusCode()});
                            return;
                        }
                    } else {
                        log.warn("Node statistics endpoint %s returned null response, using cached statistics", new Object[]{HttpRemoteNodeStats.this.stateInfoUri});
                    }
                }

                public void onFailure(Throwable t) {
                    log.error("Error fetching node stats from %s: %s", new Object[]{HttpRemoteNodeStats.this.stateInfoUri, t.getMessage()});
                    HttpRemoteNodeStats.this.lastUpdateNanos.set(System.nanoTime());
                    HttpRemoteNodeStats.this.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

