/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.JsonBodyGenerator;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.json.Codec;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.units.Duration;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.server.RequestHelpers;
import com.facebook.presto.server.smile.AdaptingJsonResponseHandler;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.server.smile.FullSmileResponseHandler;
import com.facebook.presto.server.smile.SmileBodyGenerator;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.ThreadSafe;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafe
public class RemoteNodeMemory {
    private static final Logger log = Logger.get(RemoteNodeMemory.class);
    private final InternalNode node;
    private final HttpClient httpClient;
    private final URI memoryInfoUri;
    private final Codec<MemoryInfo> memoryInfoCodec;
    private final Codec<MemoryPoolAssignmentsRequest> assignmentsRequestCodec;
    private final AtomicReference<Optional<MemoryInfo>> memoryInfo = new AtomicReference(Optional.empty());
    private final AtomicReference<Future<?>> future = new AtomicReference();
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final AtomicLong lastWarningLogged = new AtomicLong();
    private final AtomicLong currentAssignmentVersion = new AtomicLong(-1L);
    private final boolean isBinaryTransportEnabled;

    public RemoteNodeMemory(InternalNode node, HttpClient httpClient, Codec<MemoryInfo> memoryInfoCodec, Codec<MemoryPoolAssignmentsRequest> assignmentsRequestCodec, URI memoryInfoUri, boolean isBinaryTransportEnabled) {
        this.node = Objects.requireNonNull(node, "node is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.memoryInfoUri = Objects.requireNonNull(memoryInfoUri, "memoryInfoUri is null");
        this.memoryInfoCodec = Objects.requireNonNull(memoryInfoCodec, "memoryInfoCodec is null");
        this.assignmentsRequestCodec = Objects.requireNonNull(assignmentsRequestCodec, "assignmentsRequestCodec is null");
        this.isBinaryTransportEnabled = isBinaryTransportEnabled;
    }

    public long getCurrentAssignmentVersion() {
        return this.currentAssignmentVersion.get();
    }

    public Optional<MemoryInfo> getInfo() {
        return this.memoryInfo.get();
    }

    public InternalNode getNode() {
        return this.node;
    }

    public void asyncRefresh(final MemoryPoolAssignmentsRequest assignments) {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (Duration.nanosSince((long)this.lastWarningLogged.get()).toMillis() > 1000L && sinceUpdate.toMillis() > 10000L && this.future.get() != null) {
            log.warn("Memory info update request to %s has not returned in %s", new Object[]{this.memoryInfoUri, sinceUpdate.toString(TimeUnit.SECONDS)});
            this.lastWarningLogged.set(System.nanoTime());
        }
        if (sinceUpdate.toMillis() > 1000L && this.future.get() == null) {
            Request request = RequestHelpers.setContentTypeHeaders(this.isBinaryTransportEnabled, Request.Builder.preparePost()).setUri(this.memoryInfoUri).setBodyGenerator((BodyGenerator)this.createBodyGenerator(assignments)).build();
            Object responseHandler = this.isBinaryTransportEnabled ? FullSmileResponseHandler.createFullSmileResponseHandler((SmileCodec)this.memoryInfoCodec) : AdaptingJsonResponseHandler.createAdaptingJsonResponseHandler((JsonCodec)this.memoryInfoCodec);
            final HttpClient.HttpResponseFuture responseFuture = this.httpClient.executeAsync(request, responseHandler);
            this.future.compareAndSet((Future<?>)null, (Future<?>)responseFuture);
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<BaseResponse<MemoryInfo>>(){

                public void onSuccess(@Nullable BaseResponse<MemoryInfo> result) {
                    RemoteNodeMemory.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteNodeMemory.this.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                    long version = RemoteNodeMemory.this.currentAssignmentVersion.get();
                    if (result != null) {
                        if (result.hasValue()) {
                            RemoteNodeMemory.this.memoryInfo.set(Optional.ofNullable(result.getValue()));
                        }
                        if (result.getStatusCode() != HttpStatus.OK.code()) {
                            log.warn("Error fetching memory info from %s returned status %d", new Object[]{RemoteNodeMemory.this.memoryInfoUri, result.getStatusCode()});
                            return;
                        }
                    }
                    RemoteNodeMemory.this.currentAssignmentVersion.compareAndSet(version, assignments.getVersion());
                }

                public void onFailure(Throwable t) {
                    log.warn("Error fetching memory info from %s: %s", new Object[]{RemoteNodeMemory.this.memoryInfoUri, t.getMessage()});
                    RemoteNodeMemory.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteNodeMemory.this.future.compareAndSet((Future<?>)responseFuture, (Future<?>)null);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    private StaticBodyGenerator createBodyGenerator(MemoryPoolAssignmentsRequest assignments) {
        if (this.isBinaryTransportEnabled) {
            return SmileBodyGenerator.smileBodyGenerator((SmileCodec)this.assignmentsRequestCodec, assignments);
        }
        return JsonBodyGenerator.jsonBodyGenerator((JsonCodec)((JsonCodec)this.assignmentsRequestCodec), (Object)assignments);
    }
}

