/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.spi.memory.MemoryPoolInfo;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@Path(value="/v1/memory")
@RolesAllowed(value={"internal"})
public class MemoryResource {
    private final LocalMemoryManager memoryManager;
    private final TaskManager taskManager;

    @Inject
    public MemoryResource(LocalMemoryManager memoryManager, TaskManager taskManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.taskManager = Objects.requireNonNull(taskManager, "taskManager is null");
    }

    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public MemoryInfo getMemoryInfo(MemoryPoolAssignmentsRequest request) {
        this.taskManager.updateMemoryPoolAssignments(request);
        return this.memoryManager.getInfo();
    }

    @GET
    @Path(value="{poolId}")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response getMemoryInfo(@PathParam(value="poolId") String poolId) {
        if (LocalMemoryManager.GENERAL_POOL.getId().equals(poolId)) {
            return this.toSuccessfulResponse(this.memoryManager.getGeneralPool().getInfo());
        }
        if (LocalMemoryManager.RESERVED_POOL.getId().equals(poolId) && this.memoryManager.getReservedPool().isPresent()) {
            return this.toSuccessfulResponse(((MemoryPool)this.memoryManager.getReservedPool().get()).getInfo());
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private Response toSuccessfulResponse(MemoryPoolInfo memoryInfo) {
        return Response.ok().entity((Object)memoryInfo).build();
    }
}

