/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.failureDetector;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.units.Duration;
import com.facebook.airlift.units.MinDuration;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class FailureDetectorConfig {
    private boolean enabled = true;
    private double failureRatioThreshold = 0.1;
    private Duration heartbeatInterval = new Duration(500.0, TimeUnit.MILLISECONDS);
    private Duration warmupInterval = new Duration(5.0, TimeUnit.SECONDS);
    private Duration expirationGraceInterval = new Duration(10.0, TimeUnit.MINUTES);
    private int exponentialDecaySeconds = 60;

    @NotNull
    public Duration getExpirationGraceInterval() {
        return this.expirationGraceInterval;
    }

    @Config(value="failure-detector.expiration-grace-interval")
    @ConfigDescription(value="How long to wait before 'forgetting' a service after it disappears from discovery")
    public FailureDetectorConfig setExpirationGraceInterval(Duration expirationGraceInterval) {
        this.expirationGraceInterval = expirationGraceInterval;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Config(value="failure-detector.enabled")
    public FailureDetectorConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @NotNull
    public Duration getWarmupInterval() {
        return this.warmupInterval;
    }

    @Config(value="failure-detector.warmup-interval")
    @ConfigDescription(value="How long to wait after transitioning to success before considering a service alive")
    public FailureDetectorConfig setWarmupInterval(Duration warmupInterval) {
        this.warmupInterval = warmupInterval;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    @Config(value="failure-detector.heartbeat-interval")
    public FailureDetectorConfig setHeartbeatInterval(Duration interval) {
        this.heartbeatInterval = interval;
        return this;
    }

    @DecimalMin(value="0.0")
    @DecimalMax(value="1.0")
    public @DecimalMin(value="0.0") @DecimalMax(value="1.0") double getFailureRatioThreshold() {
        return this.failureRatioThreshold;
    }

    @Config(value="failure-detector.threshold")
    public FailureDetectorConfig setFailureRatioThreshold(double threshold) {
        this.failureRatioThreshold = threshold;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getExponentialDecaySeconds() {
        return this.exponentialDecaySeconds;
    }

    @Config(value="failure-detector.exponential-decay-seconds")
    public FailureDetectorConfig setExponentialDecaySeconds(int exponentialDecaySeconds) {
        this.exponentialDecaySeconds = exponentialDecaySeconds;
        return this;
    }
}

