/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.thrift;

import com.facebook.airlift.http.client.thrift.ThriftProtocolException;
import com.facebook.airlift.http.client.thrift.ThriftProtocolUtils;
import com.facebook.airlift.json.Codec;
import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Verify;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slices;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class ThriftCodecWrapper<T>
implements Codec<T> {
    private final ThriftCodec<T> thriftCodec;

    public ThriftCodecWrapper(ThriftCodec<T> thriftCodec) {
        this.thriftCodec = Objects.requireNonNull(thriftCodec, "thriftCodec is null");
    }

    public static <T> ThriftCodecWrapper<T> wrapThriftCodec(ThriftCodec<T> codec) {
        return new ThriftCodecWrapper<T>(codec);
    }

    public static <T> ThriftCodec<T> unwrapThriftCodec(Codec<T> codec) {
        Verify.verify((boolean)(codec instanceof ThriftCodecWrapper));
        return ((ThriftCodecWrapper)codec).thriftCodec;
    }

    public byte[] toBytes(T instance) {
        try {
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
            ThriftProtocolUtils.write(instance, this.thriftCodec, (Protocol)Protocol.BINARY, (OutputStream)sliceOutput);
            return sliceOutput.slice().getBytes();
        }
        catch (ThriftProtocolException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can not serialize instance to bytes", (Throwable)e);
        }
    }

    public T fromBytes(byte[] bytes) {
        try {
            return (T)ThriftProtocolUtils.read(this.thriftCodec, (Protocol)Protocol.BINARY, (InputStream)Slices.wrappedBuffer((byte[])bytes).getInput());
        }
        catch (ThriftProtocolException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Can not deserialize instance from bytes", (Throwable)e);
        }
    }

    public void writeBytes(OutputStream output, T instance) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public T readBytes(InputStream input) {
        throw new UnsupportedOperationException("Operation not supported");
    }
}

