/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.http.client.thrift.ThriftRequestUtils;
import com.facebook.airlift.http.client.thrift.ThriftResponseHandler;
import com.facebook.airlift.json.Codec;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.drift.transport.netty.codec.Protocol;
import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorTypeSerdeManager;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.metadata.HandleResolver;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.MetadataUpdates;
import com.facebook.presto.server.RequestErrorTracker;
import com.facebook.presto.server.RequestHelpers;
import com.facebook.presto.server.SimpleHttpResponseCallback;
import com.facebook.presto.server.SimpleHttpResponseHandler;
import com.facebook.presto.server.TaskResourceUtils;
import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.server.smile.AdaptingJsonResponseHandler;
import com.facebook.presto.server.smile.BaseResponse;
import com.facebook.presto.server.smile.FullSmileResponseHandler;
import com.facebook.presto.server.thrift.ThriftCodecWrapper;
import com.facebook.presto.server.thrift.ThriftHttpResponseHandler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import io.netty.channel.EventLoop;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class TaskInfoFetcherWithEventLoop
implements SimpleHttpResponseCallback<TaskInfo> {
    private final TaskId taskId;
    private final Consumer<Throwable> onFail;
    private final StateMachine<TaskInfo> taskInfo;
    private final StateMachine<Optional<TaskInfo>> finalTaskInfo;
    private final Codec<TaskInfo> taskInfoCodec;
    private final Codec<MetadataUpdates> metadataUpdatesCodec;
    private final long updateIntervalMillis;
    private final Duration taskInfoRefreshMaxWait;
    private long lastUpdateNanos;
    private final EventLoop taskEventLoop;
    private final HttpClient httpClient;
    private final RequestErrorTracker errorTracker;
    private final boolean summarizeTaskInfo;
    private long currentRequestStartNanos;
    private final RemoteTaskStats stats;
    private boolean running;
    private ScheduledFuture<?> scheduledFuture;
    private ListenableFuture<BaseResponse<TaskInfo>> future;
    private ListenableFuture<?> metadataUpdateFuture;
    private final boolean isBinaryTransportEnabled;
    private final boolean isThriftTransportEnabled;
    private final Session session;
    private final MetadataManager metadataManager;
    private final QueryManager queryManager;
    private final HandleResolver handleResolver;
    private final ConnectorTypeSerdeManager connectorTypeSerdeManager;
    private final Protocol thriftProtocol;

    public TaskInfoFetcherWithEventLoop(Consumer<Throwable> onFail, TaskInfo initialTask, HttpClient httpClient, Duration updateInterval, Duration taskInfoRefreshMaxWait, Codec<TaskInfo> taskInfoCodec, Codec<MetadataUpdates> metadataUpdatesCodec, Duration maxErrorDuration, boolean summarizeTaskInfo, EventLoop taskEventLoop, RemoteTaskStats stats, boolean isBinaryTransportEnabled, boolean isThriftTransportEnabled, Session session, MetadataManager metadataManager, QueryManager queryManager, HandleResolver handleResolver, ConnectorTypeSerdeManager connectorTypeSerdeManager, Protocol thriftProtocol) {
        Objects.requireNonNull(initialTask, "initialTask is null");
        this.taskId = initialTask.getTaskId();
        this.onFail = Objects.requireNonNull(onFail, "onFail is null");
        this.taskInfo = new StateMachine("task " + this.taskId, (Executor)taskEventLoop, (Object)initialTask);
        this.finalTaskInfo = new StateMachine("task-" + this.taskId, (Executor)taskEventLoop, Optional.empty());
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.metadataUpdatesCodec = Objects.requireNonNull(metadataUpdatesCodec, "metadataUpdatesCodec is null");
        this.updateIntervalMillis = Objects.requireNonNull(updateInterval, "updateInterval is null").toMillis();
        this.taskInfoRefreshMaxWait = Objects.requireNonNull(taskInfoRefreshMaxWait, "taskInfoRefreshMaxWait is null");
        this.errorTracker = RequestErrorTracker.taskRequestErrorTracker(this.taskId, initialTask.getTaskStatus().getSelf(), maxErrorDuration, (ScheduledExecutorService)taskEventLoop, "getting info for task");
        this.summarizeTaskInfo = summarizeTaskInfo;
        this.taskEventLoop = Objects.requireNonNull(taskEventLoop, "taskEventLoop is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.isBinaryTransportEnabled = isBinaryTransportEnabled;
        this.isThriftTransportEnabled = isThriftTransportEnabled;
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadataManager = Objects.requireNonNull(metadataManager, "metadataManager is null");
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.handleResolver = Objects.requireNonNull(handleResolver, "handleResolver is null");
        this.connectorTypeSerdeManager = Objects.requireNonNull(connectorTypeSerdeManager, "connectorTypeSerdeManager is null");
        this.thriftProtocol = Objects.requireNonNull(thriftProtocol, "thriftProtocol is null");
    }

    public TaskInfo getTaskInfo() {
        return (TaskInfo)this.taskInfo.get();
    }

    public void start() {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduleUpdate();
    }

    private void stop() {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        this.running = false;
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public void addFinalTaskInfoListener(StateMachine.StateChangeListener<TaskInfo> stateChangeListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener fireOnceStateChangeListener = finalTaskInfo -> {
            if (finalTaskInfo.isPresent() && done.compareAndSet(false, true)) {
                stateChangeListener.stateChanged((Object)((TaskInfo)finalTaskInfo.get()));
            }
        };
        this.finalTaskInfo.addStateChangeListener(fireOnceStateChangeListener);
        fireOnceStateChangeListener.stateChanged((Object)((Optional)this.finalTaskInfo.get()));
    }

    private void scheduleUpdate() {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        this.scheduledFuture = this.taskEventLoop.scheduleWithFixedDelay(() -> {
            try {
                if (this.future != null && !this.future.isDone()) {
                    return;
                }
                if (Duration.nanosSince((long)this.lastUpdateNanos).toMillis() >= this.updateIntervalMillis) {
                    this.sendNextRequest();
                }
            }
            catch (Throwable t) {
                this.fatal(t);
                throw t;
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private void sendNextRequest() {
        Object responseHandler;
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        TaskInfo taskInfo = this.getTaskInfo();
        TaskStatus taskStatus = taskInfo.getTaskStatus();
        if (!this.running) {
            return;
        }
        if (TaskInfoFetcherWithEventLoop.isDone(this.getTaskInfo())) {
            this.stop();
            return;
        }
        if (this.future != null && !this.future.isDone()) {
            return;
        }
        ListenableFuture<?> errorRateLimit = this.errorTracker.acquireRequestPermit();
        if (!errorRateLimit.isDone()) {
            errorRateLimit.addListener(this::sendNextRequest, (Executor)this.taskEventLoop);
            return;
        }
        MetadataUpdates metadataUpdateRequests = taskInfo.getMetadataUpdates();
        if (!metadataUpdateRequests.getMetadataUpdates().isEmpty()) {
            this.scheduleMetadataUpdates(metadataUpdateRequests);
        }
        HttpUriBuilder httpUriBuilder = HttpUriBuilder.uriBuilderFrom((URI)taskStatus.getSelf());
        URI uri = this.summarizeTaskInfo ? httpUriBuilder.addParameter("summarize", new String[0]).build() : httpUriBuilder.build();
        Request.Builder requestBuilder = RequestHelpers.setContentTypeHeaders(this.isBinaryTransportEnabled, Request.Builder.prepareGet());
        if (this.isThriftTransportEnabled) {
            requestBuilder = ThriftRequestUtils.prepareThriftGet((Protocol)this.thriftProtocol);
            responseHandler = new ThriftResponseHandler(ThriftCodecWrapper.unwrapThriftCodec(this.taskInfoCodec));
        } else {
            responseHandler = this.isBinaryTransportEnabled ? FullSmileResponseHandler.createFullSmileResponseHandler((SmileCodec)this.taskInfoCodec) : AdaptingJsonResponseHandler.createAdaptingJsonResponseHandler((JsonCodec)this.taskInfoCodec);
        }
        if (this.taskInfoRefreshMaxWait.toMillis() != 0L) {
            requestBuilder.setHeader("X-Presto-Current-State", taskStatus.getState().toString()).setHeader("X-Presto-Max-Wait", this.taskInfoRefreshMaxWait.toString());
        }
        Request request = requestBuilder.setUri(uri).build();
        this.errorTracker.startRequest();
        this.future = this.httpClient.executeAsync(request, (ResponseHandler)responseHandler);
        this.currentRequestStartNanos = System.nanoTime();
        Object callback = this.isThriftTransportEnabled ? new ThriftHttpResponseHandler<TaskInfo>(this, request.getUri(), this.stats.getHttpResponseStats(), (ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR) : new SimpleHttpResponseHandler<TaskInfo>(this, request.getUri(), this.stats.getHttpResponseStats(), (ErrorCodeSupplier)StandardErrorCode.REMOTE_TASK_ERROR);
        Futures.addCallback(this.future, callback, (Executor)this.taskEventLoop);
    }

    void updateTaskInfo(TaskInfo newValue) {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        boolean updated = this.taskInfo.setIf((Object)newValue, oldValue -> {
            TaskStatus oldTaskStatus = oldValue.getTaskStatus();
            TaskStatus newTaskStatus = newValue.getTaskStatus();
            if (oldTaskStatus.getState().isDone()) {
                return false;
            }
            return newTaskStatus.getVersion() >= oldTaskStatus.getVersion();
        });
        if (updated && newValue.getTaskStatus().getState().isDone()) {
            this.finalTaskInfo.compareAndSet(Optional.empty(), Optional.of(newValue));
            this.stop();
        }
    }

    public void success(TaskInfo newValue) {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        this.lastUpdateNanos = System.nanoTime();
        long startNanos = this.currentRequestStartNanos;
        this.updateStats(startNanos);
        this.errorTracker.requestSucceeded();
        if (this.isThriftTransportEnabled) {
            newValue = TaskResourceUtils.convertFromThriftTaskInfo((TaskInfo)newValue, (ConnectorTypeSerdeManager)this.connectorTypeSerdeManager, (HandleResolver)this.handleResolver);
        }
        this.updateTaskInfo(newValue);
    }

    public void failed(Throwable cause) {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        this.lastUpdateNanos = System.nanoTime();
        try {
            if (!TaskInfoFetcherWithEventLoop.isDone(this.getTaskInfo())) {
                this.errorTracker.requestFailed(cause);
            }
        }
        catch (Error e) {
            this.onFail.accept(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.onFail.accept(e);
        }
    }

    public void fatal(Throwable cause) {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        this.onFail.accept(cause);
    }

    private void updateStats(long currentRequestStartNanos) {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        this.stats.infoRoundTripMillis(Duration.nanosSince((long)currentRequestStartNanos).toMillis());
    }

    private static boolean isDone(TaskInfo taskInfo) {
        return taskInfo.getTaskStatus().getState().isDone();
    }

    private void scheduleMetadataUpdates(MetadataUpdates metadataUpdateRequests) {
        MetadataUpdates results = this.metadataManager.getMetadataUpdateResults(this.session, this.queryManager, metadataUpdateRequests, this.taskId.getQueryId());
        this.taskEventLoop.execute(() -> this.sendMetadataUpdates(results));
    }

    private void sendMetadataUpdates(MetadataUpdates results) {
        Verify.verify((boolean)this.taskEventLoop.inEventLoop());
        TaskStatus taskStatus = this.getTaskInfo().getTaskStatus();
        if (TaskInfoFetcherWithEventLoop.isDone(this.getTaskInfo())) {
            this.stop();
            return;
        }
        if (this.metadataUpdateFuture != null && !this.metadataUpdateFuture.isDone()) {
            return;
        }
        byte[] metadataUpdatesJson = this.metadataUpdatesCodec.toBytes((Object)results);
        Request request = RequestHelpers.setContentTypeHeaders(this.isBinaryTransportEnabled, Request.Builder.preparePost()).setUri(HttpUriBuilder.uriBuilderFrom((URI)taskStatus.getSelf()).appendPath("metadataresults").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((byte[])metadataUpdatesJson)).build();
        this.errorTracker.startRequest();
        this.metadataUpdateFuture = this.httpClient.executeAsync(request, (ResponseHandler)new ResponseHandler<Response, RuntimeException>(){

            public Response handleException(Request request, Exception exception) {
                throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
            }

            public Response handle(Request request, Response response) {
                return response;
            }
        });
        this.currentRequestStartNanos = System.nanoTime();
    }
}

