/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.resourcemanager;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.http.client.JsonResponseHandler;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ForResourceManager;
import com.facebook.presto.resourcemanager.ResourceManagerClusterStateProvider;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.spi.QueryId;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/queryState")
@RolesAllowed(value={"user", "admin"})
public class DistributedQueryInfoResource {
    private static final Logger log = Logger.get(DistributedQueryInfoResource.class);
    private final ResourceManagerClusterStateProvider clusterStateProvider;
    private final InternalNodeManager internalNodeManager;
    private final ListeningExecutorService executor;
    private final ResourceManagerProxy proxyHelper;
    private final JsonCodec<List<QueryStateInfo>> jsonCodec;
    private final HttpClient httpClient;

    @Inject
    public DistributedQueryInfoResource(ResourceManagerClusterStateProvider clusterStateProvider, InternalNodeManager internalNodeManager, @ForResourceManager ListeningExecutorService executor, ResourceManagerProxy proxyHelper, JsonCodec<List<QueryStateInfo>> jsonCodec, @ForResourceManager HttpClient httpClient) {
        this.clusterStateProvider = Objects.requireNonNull(clusterStateProvider, "clusterStateProvider is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "proxyHelper is null");
        this.jsonCodec = Objects.requireNonNull(jsonCodec, "jsonCodec is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    @GET
    public void getAllQueryInfo(@QueryParam(value="user") String user, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        try {
            Set coordinators = this.internalNodeManager.getCoordinators();
            ImmutableList.Builder queryStateInfoFutureBuilder = ImmutableList.builder();
            for (InternalNode coordinator : coordinators) {
                queryStateInfoFutureBuilder.add(this.getQueryStateFromCoordinator(uriInfo, coordinator));
            }
            ImmutableList queryStateInfoFutureList = queryStateInfoFutureBuilder.build();
            Futures.whenAllComplete((Iterable)queryStateInfoFutureList).call(() -> DistributedQueryInfoResource.lambda$getAllQueryInfo$0((List)queryStateInfoFutureList, asyncResponse), (Executor)this.executor);
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Error in getting query info");
            asyncResponse.resume((Object)Response.serverError().entity((Object)ex.getMessage()).build());
        }
    }

    @GET
    @Path(value="{queryId}")
    @Produces(value={"application/json"})
    public void getQueryStateInfo(@PathParam(value="queryId") QueryId queryId, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse) throws WebApplicationException {
        this.proxyQueryInfoResponse(servletRequest, asyncResponse, uriInfo, queryId);
    }

    private ListenableFuture<List<QueryStateInfo>> getQueryStateFromCoordinator(UriInfo uriInfo, InternalNode coordinatorNode) throws IOException {
        URI uri = uriInfo.getRequestUriBuilder().queryParam("includeLocalQueryOnly", new Object[]{true}).scheme(coordinatorNode.getInternalUri().getScheme()).host(coordinatorNode.getHostAndPort().toInetAddress().getHostName()).port(coordinatorNode.getInternalUri().getPort()).build(new Object[0]);
        Request request = Request.Builder.prepareGet().setUri(uri).build();
        return this.httpClient.executeAsync(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(this.jsonCodec));
    }

    private void proxyQueryInfoResponse(HttpServletRequest servletRequest, AsyncResponse asyncResponse, UriInfo uriInfo, QueryId queryId) {
        Optional<BasicQueryInfo> queryInfo = this.clusterStateProvider.getClusterQueries().stream().filter(query -> query.getQueryId().equals((Object)queryId)).findFirst();
        if (!queryInfo.isPresent()) {
            asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").build());
            return;
        }
        this.proxyHelper.performRequest(servletRequest, asyncResponse, HttpUriBuilder.uriBuilderFrom((URI)queryInfo.get().getSelf()).replacePath(uriInfo.getPath()).build());
    }

    private static /* synthetic */ Boolean lambda$getAllQueryInfo$0(List queryStateInfoFutureList, AsyncResponse asyncResponse) throws Exception {
        try {
            ArrayList queryStateInfoList = new ArrayList();
            for (Future queryStateInfoFuture : queryStateInfoFutureList) {
                queryStateInfoList.addAll((Collection)queryStateInfoFuture.get());
            }
            return asyncResponse.resume((Object)Response.ok(queryStateInfoList).build());
        }
        catch (Exception ex) {
            log.error((Throwable)ex, "Error in getting query info from one of the coordinators");
            return asyncResponse.resume((Object)Response.serverError().entity((Object)ex.getMessage()).build());
        }
    }
}

