/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AccessControlInfo;
import com.facebook.presto.spi.analyzer.AccessControlReferences;
import com.facebook.presto.spi.analyzer.AnalyzerContext;
import com.facebook.presto.spi.analyzer.AnalyzerOptions;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.analyzer.QueryAnalyzer;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.sql.analyzer.BuiltInQueryAnalyzer;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.google.common.base.Preconditions;
import java.util.Optional;

public class AnalyzerUtil {
    private AnalyzerUtil() {
    }

    public static ParsingOptions createParsingOptions() {
        return ParsingOptions.builder().build();
    }

    public static ParsingOptions createParsingOptions(Session session) {
        return AnalyzerUtil.createParsingOptions(session, WarningCollector.NOOP);
    }

    public static ParsingOptions createParsingOptions(Session session, WarningCollector warningCollector) {
        return ParsingOptions.builder().setDecimalLiteralTreatment(SystemSessionProperties.isParseDecimalLiteralsAsDouble(session) ? ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE : ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL).setWarningConsumer(warning -> warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PARSER_WARNING, warning.getMessage()))).build();
    }

    public static AnalyzerOptions createAnalyzerOptions(Session session) {
        return AnalyzerUtil.createAnalyzerOptions(session, WarningCollector.NOOP);
    }

    public static AnalyzerOptions createAnalyzerOptions(Session session, WarningCollector warningCollector) {
        return AnalyzerOptions.builder().setParseDecimalLiteralsAsDouble(SystemSessionProperties.isParseDecimalLiteralsAsDouble(session)).setLogFormattedQueryEnabled(SystemSessionProperties.isLogFormattedQueryEnabled(session)).setWarningHandlingLevel(SystemSessionProperties.getWarningHandlingLevel(session)).setWarningCollector(warningCollector).build();
    }

    public static AnalyzerContext getAnalyzerContext(QueryAnalyzer queryAnalyzer, MetadataResolver metadataResolver, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator, Session session) {
        if (queryAnalyzer instanceof BuiltInQueryAnalyzer) {
            return BuiltInQueryAnalyzer.getBuiltInAnalyzerContext(metadataResolver, idAllocator, variableAllocator, session);
        }
        return new AnalyzerContext(metadataResolver, idAllocator, variableAllocator);
    }

    public static void checkAccessPermissions(AccessControlReferences accessControlReferences) {
        AnalyzerUtil.checkAccessPermissionsForTable(accessControlReferences);
        AnalyzerUtil.checkAccessPermissionsForColumns(accessControlReferences);
    }

    private static void checkAccessPermissionsForColumns(AccessControlReferences accessControlReferences) {
        accessControlReferences.getTableColumnAndSubfieldReferencesForAccessControl().forEach((accessControlInfo, tableColumnReferences) -> tableColumnReferences.forEach((tableName, columns) -> {
            Optional transactionId = accessControlInfo.getTransactionId();
            Preconditions.checkState((boolean)transactionId.isPresent(), (Object)"transactionId is not present");
            accessControlInfo.getAccessControl().checkCanSelectFromColumns((TransactionId)transactionId.get(), accessControlInfo.getIdentity(), accessControlInfo.getAccessControlContext(), tableName, columns);
        }));
    }

    private static void checkAccessPermissionsForTable(AccessControlReferences accessControlReferences) {
        accessControlReferences.getTableReferences().forEach((accessControlRole, accessControlInfoForTables) -> accessControlInfoForTables.forEach(accessControlInfoForTable -> {
            AccessControlInfo accessControlInfo = accessControlInfoForTable.getAccessControlInfo();
            AccessControl accessControl = accessControlInfo.getAccessControl();
            QualifiedObjectName tableName = accessControlInfoForTable.getTableName();
            Identity identity = accessControlInfo.getIdentity();
            Optional transactionId = accessControlInfo.getTransactionId();
            Preconditions.checkState((boolean)transactionId.isPresent(), (Object)"transactionId is not present");
            AccessControlContext accessControlContext = accessControlInfo.getAccessControlContext();
            switch (accessControlRole) {
                case TABLE_CREATE: {
                    accessControl.checkCanCreateTable((TransactionId)transactionId.get(), identity, accessControlContext, tableName);
                    break;
                }
                case TABLE_INSERT: {
                    accessControl.checkCanInsertIntoTable((TransactionId)transactionId.get(), identity, accessControlContext, tableName);
                    break;
                }
                case TABLE_DELETE: {
                    accessControl.checkCanDeleteFromTable((TransactionId)transactionId.get(), identity, accessControlContext, tableName);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported access control role found: " + accessControlRole);
                }
            }
        }));
    }
}

