/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.facebook.presto.type.khyperloglog.KHyperLogLogState;
import com.facebook.presto.type.khyperloglog.KHyperLogLogStateFactory;
import com.facebook.presto.type.khyperloglog.KHyperLogLogStateSerializer;
import com.facebook.presto.type.khyperloglog.KHyperLogLogType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class MergeKHyperLogLogWithLimitAggregationFunction
extends SqlAggregationFunction {
    private static final String NAME = "merge";
    private static final MethodHandle INPUT_FUNCTION = Reflection.methodHandle(MergeKHyperLogLogWithLimitAggregationFunction.class, "input", KHyperLogLogState.class, Slice.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MergeKHyperLogLogWithLimitAggregationFunction.class, "output", KHyperLogLogState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MergeKHyperLogLogWithLimitAggregationFunction.class, "combine", KHyperLogLogState.class, KHyperLogLogState.class);
    private final long groupLimit;

    public MergeKHyperLogLogWithLimitAggregationFunction(long groupLimit) {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), KHyperLogLogType.K_HYPER_LOG_LOG.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)KHyperLogLogType.K_HYPER_LOG_LOG.getTypeSignature()));
        this.groupLimit = groupLimit;
    }

    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="KHyperLogLog") Slice value) {
        KHyperLogLog instance = KHyperLogLog.newInstance(value);
        MergeKHyperLogLogWithLimitAggregationFunction.merge(state, instance);
    }

    public static void combine(@AggregationState KHyperLogLogState state, @AggregationState KHyperLogLogState otherState) {
        MergeKHyperLogLogWithLimitAggregationFunction.merge(state, otherState.getKHLL());
    }

    private static void merge(@AggregationState KHyperLogLogState state, KHyperLogLog instance) {
        if (state.getKHLL() == null) {
            state.setKHLL(instance);
        } else {
            state.getKHLL().mergeWith(instance);
        }
    }

    public static void output(@AggregationState KHyperLogLogState state, BlockBuilder out) {
        if (state.getKHLL() == null) {
            out.appendNull();
        } else {
            KHyperLogLogType.K_HYPER_LOG_LOG.writeSlice(out, state.getKHLL().serialize());
        }
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MergeKHyperLogLogWithLimitAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)((Object)KHyperLogLogType.K_HYPER_LOG_LOG));
        Class<KHyperLogLogState> stateInterface = KHyperLogLogState.class;
        KHyperLogLogStateSerializer stateSerializer = new KHyperLogLogStateSerializer();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, KHyperLogLogType.K_HYPER_LOG_LOG.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), (List)ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, (Type)KHyperLogLogType.K_HYPER_LOG_LOG)), INPUT_FUNCTION, COMBINE_FUNCTION, OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)new KHyperLogLogStateFactory(this.groupLimit))), (Type)KHyperLogLogType.K_HYPER_LOG_LOG);
        Type intermediateType = stateSerializer.getSerializedType();
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)KHyperLogLogType.K_HYPER_LOG_LOG, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    public String getDescription() {
        return "Merge KHyperLogLog sketches";
    }
}

