/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.facebook.presto.type.khyperloglog.KHyperLogLogState;
import com.facebook.presto.type.khyperloglog.KHyperLogLogStateFactory;
import com.facebook.presto.type.khyperloglog.KHyperLogLogStateSerializer;
import com.facebook.presto.type.khyperloglog.KHyperLogLogType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class KHyperLogLogWithLimitAggregationFunction
extends SqlAggregationFunction {
    private static final String NAME = "khyperloglog_agg";
    private static final KHyperLogLogStateSerializer SERIALIZER = new KHyperLogLogStateSerializer();
    private static final MethodHandle LONG_LONG_INPUT_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "input", KHyperLogLogState.class, Long.TYPE, Long.TYPE);
    private static final MethodHandle SLICE_LONG_INPUT_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "input", KHyperLogLogState.class, Slice.class, Long.TYPE);
    private static final MethodHandle DOUBLE_LONG_INPUT_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "input", KHyperLogLogState.class, Double.TYPE, Long.TYPE);
    private static final MethodHandle LONG_SLICE_INPUT_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "input", KHyperLogLogState.class, Long.TYPE, Slice.class);
    private static final MethodHandle SLICE_SLICE_INPUT_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "input", KHyperLogLogState.class, Slice.class, Slice.class);
    private static final MethodHandle DOUBLE_SLICE_INPUT_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "input", KHyperLogLogState.class, Double.TYPE, Slice.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "output", KHyperLogLogState.class, BlockBuilder.class);
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(KHyperLogLogWithLimitAggregationFunction.class, "combine", KHyperLogLogState.class, KHyperLogLogState.class);
    private final long groupLimit;

    public KHyperLogLogWithLimitAggregationFunction(long groupLimit) {
        super(NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable((String)"E"), (Object)Signature.typeVariable((String)"T")), (List<LongVariableConstraint>)ImmutableList.of(), KHyperLogLogType.K_HYPER_LOG_LOG.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"E"), (Object)TypeSignature.parseTypeSignature((String)"T")));
        this.groupLimit = groupLimit;
    }

    public static String getFunctionName() {
        return NAME;
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type firstInputType = boundVariables.getTypeVariable("E");
        Type secondInputType = boundVariables.getTypeVariable("T");
        return this.generateAggregation(firstInputType, secondInputType);
    }

    private BuiltInAggregationFunctionImplementation generateAggregation(Type firstInputType, Type secondInputType) {
        DynamicClassLoader classLoader = new DynamicClassLoader(KHyperLogLogWithLimitAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)firstInputType, (Object)secondInputType);
        Class<KHyperLogLogState> stateInterface = KHyperLogLogState.class;
        KHyperLogLogStateSerializer stateSerializer = new KHyperLogLogStateSerializer();
        MethodHandle inputFunction = KHyperLogLogWithLimitAggregationFunction.getMethodHandle(firstInputType, secondInputType);
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(NAME, KHyperLogLogType.K_HYPER_LOG_LOG.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), (List)ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, firstInputType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, secondInputType)), inputFunction, COMBINE_FUNCTION, OUTPUT_FUNCTION, (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)new KHyperLogLogStateFactory(this.groupLimit))), (Type)KHyperLogLogType.K_HYPER_LOG_LOG);
        Type intermediateType = stateSerializer.getSerializedType();
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(NAME, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), (Type)KHyperLogLogType.K_HYPER_LOG_LOG, true, false, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static MethodHandle getMethodHandle(Type firstInputType, Type secondInputType) {
        MethodHandle inputFunction;
        if (firstInputType.getJavaType() == Long.TYPE && secondInputType.getJavaType() == Long.TYPE) {
            inputFunction = LONG_LONG_INPUT_FUNCTION;
        } else if (firstInputType.getJavaType() == Slice.class && secondInputType.getJavaType() == Long.TYPE) {
            inputFunction = SLICE_LONG_INPUT_FUNCTION;
        } else if (firstInputType.getJavaType() == Double.TYPE && secondInputType.getJavaType() == Long.TYPE) {
            inputFunction = DOUBLE_LONG_INPUT_FUNCTION;
        } else if (firstInputType.getJavaType() == Long.TYPE && secondInputType.getJavaType() == Slice.class) {
            inputFunction = LONG_SLICE_INPUT_FUNCTION;
        } else if (firstInputType.getJavaType() == Slice.class && secondInputType.getJavaType() == Slice.class) {
            inputFunction = SLICE_SLICE_INPUT_FUNCTION;
        } else if (firstInputType.getJavaType() == Double.TYPE && secondInputType.getJavaType() == Slice.class) {
            inputFunction = DOUBLE_SLICE_INPUT_FUNCTION;
        } else {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "input types for khyperloglog_agg are not supported");
        }
        return inputFunction;
    }

    public String getDescription() {
        return "Returns the KHyperLogLog sketch that represents the relationship between columns x and y. The MinHash structure summarizes x and the HyperLogLog sketches represent y values linked to x values.";
    }

    public static void input(KHyperLogLogState state, long value, long uii) {
        if (state.getKHLL() == null) {
            state.setKHLL(new KHyperLogLog());
        }
        state.getKHLL().add(value, uii);
    }

    public static void input(KHyperLogLogState state, Slice value, long uii) {
        if (state.getKHLL() == null) {
            state.setKHLL(new KHyperLogLog());
        }
        state.getKHLL().add(value, uii);
    }

    public static void input(KHyperLogLogState state, double value, long uii) {
        KHyperLogLogWithLimitAggregationFunction.input(state, Double.doubleToLongBits(value), uii);
    }

    public static void input(KHyperLogLogState state, long value, Slice uii) {
        KHyperLogLogWithLimitAggregationFunction.input(state, value, XxHash64.hash((Slice)uii));
    }

    public static void input(KHyperLogLogState state, Slice value, Slice uii) {
        KHyperLogLogWithLimitAggregationFunction.input(state, value, XxHash64.hash((Slice)uii));
    }

    public static void input(KHyperLogLogState state, double value, Slice uii) {
        KHyperLogLogWithLimitAggregationFunction.input(state, Double.doubleToLongBits(value), XxHash64.hash((Slice)uii));
    }

    public static void combine(KHyperLogLogState state, KHyperLogLogState otherState) {
        if (state.getKHLL() == null) {
            KHyperLogLog copy = new KHyperLogLog();
            copy.mergeWith(otherState.getKHLL());
            state.setKHLL(copy);
        } else {
            state.getKHLL().mergeWith(otherState.getKHLL());
        }
    }

    public static void output(KHyperLogLogState state, BlockBuilder out) {
        SERIALIZER.serialize(state, out);
    }
}

