/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.CoordinatorPlugin;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.eventlistener.EventListener;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.planner.ConnectorPlanOptimizerManager;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.testing.ExpectedQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingAccessControlManager;
import com.facebook.presto.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.intellij.lang.annotations.Language;

public interface QueryRunner
extends ExpectedQueryRunner {
    public int getNodeCount();

    public Session getDefaultSession();

    public TransactionManager getTransactionManager();

    public Metadata getMetadata();

    public SplitManager getSplitManager();

    public PageSourceManager getPageSourceManager();

    public NodePartitioningManager getNodePartitioningManager();

    public ConnectorPlanOptimizerManager getPlanOptimizerManager();

    public StatsCalculator getStatsCalculator();

    public Optional<EventListener> getEventListener();

    public TestingAccessControlManager getAccessControl();

    public MaterializedResult execute(@Language(value="SQL") String var1);

    public MaterializedResult execute(Session var1, @Language(value="SQL") String var2);

    @Override
    default public MaterializedResult execute(Session session, @Language(value="SQL") String sql, List<? extends Type> resultTypes) {
        return this.execute(session, sql);
    }

    default public MaterializedResultWithPlan executeWithPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        throw new UnsupportedOperationException();
    }

    default public Plan createPlan(Session session, @Language(value="SQL") String sql, WarningCollector warningCollector) {
        throw new UnsupportedOperationException();
    }

    public List<QualifiedObjectName> listTables(Session var1, String var2, String var3);

    public boolean tableExists(Session var1, String var2);

    public void installPlugin(Plugin var1);

    default public void installCoordinatorPlugin(CoordinatorPlugin plugin) {
        throw new UnsupportedOperationException();
    }

    public void createCatalog(String var1, String var2, Map<String, String> var3);

    public void loadFunctionNamespaceManager(String var1, String var2, Map<String, String> var3);

    public Lock getExclusiveLock();

    public static class MaterializedResultWithPlan {
        private final MaterializedResult materializedResult;
        private final Plan queryPlan;

        public MaterializedResultWithPlan(MaterializedResult materializedResult, Plan queryPlan) {
            this.materializedResult = materializedResult;
            this.queryPlan = queryPlan;
        }

        public MaterializedResult getMaterializedResult() {
            return this.materializedResult;
        }

        public Plan getQueryPlan() {
            return this.queryPlan;
        }
    }
}

