/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.UnresolvedSymbolExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionExtractor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class VerifyNoUnresolvedSymbolExpression
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        List expressions = (List)ExpressionExtractor.extractExpressions(plan).stream().collect(ImmutableList.toImmutableList());
        for (RowExpression expression : expressions) {
            expression.accept((RowExpressionVisitor)new DefaultRowExpressionTraversalVisitor<Void>(){

                public Void visitUnresolvedSymbolExpression(UnresolvedSymbolExpression node, Void context) {
                    throw new IllegalStateException(String.format("Unexpected UnresolvedSymbolExpression in logical plan: %s", String.join((CharSequence)".", node.getName())));
                }
            }, null);
        }
    }
}

