/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.StreamPreferredProperties;
import com.facebook.presto.sql.planner.optimizations.StreamPropertyDerivations;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ValidateStreamingJoins
implements PlanChecker.Checker {
    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept((PlanVisitor)new Visitor(session, metadata, sqlParser, types, warningCollector), null);
    }

    private static final class Visitor
    extends InternalPlanVisitor<Void, Void> {
        private final Session session;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final TypeProvider types;
        private final WarningCollector warningCollector;

        private Visitor(Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
            this.session = session;
            this.metadata = metadata;
            this.sqlParser = sqlParser;
            this.types = types;
            this.warningCollector = warningCollector;
        }

        public Void visitPlan(PlanNode node, Void context) {
            node.getSources().forEach(source -> {
                Void cfr_ignored_0 = (Void)source.accept((PlanVisitor)this, (Object)context);
            });
            return null;
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            if (!PlanNodeSearcher.searchFrom(node).where(RemoteSourceNode.class::isInstance).matches()) {
                List buildJoinVariables = (List)node.getCriteria().stream().map(EquiJoinClause::getRight).collect(ImmutableList.toImmutableList());
                StreamPreferredProperties requiredBuildProperty = SystemSessionProperties.getTaskConcurrency(this.session) > 1 ? StreamPreferredProperties.exactlyPartitionedOn(buildJoinVariables) : StreamPreferredProperties.singleStream();
                StreamPropertyDerivations.StreamProperties buildProperties = StreamPropertyDerivations.derivePropertiesRecursively(node.getRight(), this.metadata, this.session, this.types, this.sqlParser);
                Preconditions.checkArgument((boolean)requiredBuildProperty.isSatisfiedBy(buildProperties), (String)"Build side needs an additional local exchange for join: %s", (Object)node.getId());
                StreamPreferredProperties requiredProbeProperty = SystemSessionProperties.isSpillEnabled(this.session) && SystemSessionProperties.isJoinSpillingEnabled(this.session) ? StreamPreferredProperties.fixedParallelism() : StreamPreferredProperties.defaultParallelism(this.session);
                StreamPropertyDerivations.StreamProperties probeProperties = StreamPropertyDerivations.derivePropertiesRecursively(node.getLeft(), this.metadata, this.session, this.types, this.sqlParser);
                Preconditions.checkArgument((boolean)requiredProbeProperty.isSatisfiedBy(probeProperties), (String)"Probe side needs an additional local exchange for join: %s", (Object)node.getId());
            }
            return null;
        }
    }
}

