/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.IntermediateFormExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanChecker;
import com.google.common.base.Preconditions;
import java.util.List;

public class CheckNoTimestampWithTimezoneType
implements PlanChecker.Checker {
    private static final String errorMessage = "Timestamp with Timezone type is not supported in Prestissimo";

    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, TypeProvider types, WarningCollector warningCollector) {
        planNode.accept((PlanVisitor)new Visitor(), null);
    }

    private static boolean hasTimestampWithTimezoneType(Type type) {
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE)) {
            return true;
        }
        if (type instanceof ArrayType) {
            return CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            return CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(((MapType)type).getKeyType()) || CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(((MapType)type).getValueType());
        }
        if (type instanceof RowType) {
            return ((RowType)type).getTypeParameters().stream().anyMatch(CheckNoTimestampWithTimezoneType::hasTimestampWithTimezoneType);
        }
        return false;
    }

    private static class NoTimeStampWithTimeZoneTypeChecker
    extends DefaultRowExpressionTraversalVisitor<Void> {
        private NoTimeStampWithTimeZoneTypeChecker() {
        }

        public Void visitConstant(ConstantExpression literal, Void context) {
            Preconditions.checkState((!CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(literal.getType()) ? 1 : 0) != 0, (Object)CheckNoTimestampWithTimezoneType.errorMessage);
            return null;
        }

        public Void visitVariableReference(VariableReferenceExpression reference, Void context) {
            Preconditions.checkState((!CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(reference.getType()) ? 1 : 0) != 0, (Object)CheckNoTimestampWithTimezoneType.errorMessage);
            return null;
        }

        public Void visitInputReference(InputReferenceExpression input, Void context) {
            Preconditions.checkState((!CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(input.getType()) ? 1 : 0) != 0, (Object)CheckNoTimestampWithTimezoneType.errorMessage);
            return null;
        }

        public Void visitCall(CallExpression call, Void context) {
            Preconditions.checkState((!CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(call.getType()) ? 1 : 0) != 0, (Object)CheckNoTimestampWithTimezoneType.errorMessage);
            return super.visitCall(call, (Object)context);
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            Preconditions.checkState((!CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(specialForm.getType()) ? 1 : 0) != 0, (Object)CheckNoTimestampWithTimezoneType.errorMessage);
            return super.visitSpecialForm(specialForm, (Object)context);
        }

        public Void visitIntermediateFormExpression(IntermediateFormExpression expression, Void context) {
            Preconditions.checkState((!CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(expression.getType()) ? 1 : 0) != 0, (Object)CheckNoTimestampWithTimezoneType.errorMessage);
            return super.visitIntermediateFormExpression(expression, (Object)context);
        }
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final NoTimeStampWithTimeZoneTypeChecker noTimeStampWithTimeZoneTypeChecker = new NoTimeStampWithTimeZoneTypeChecker();

        @Override
        public Void visitPlan(PlanNode node, Void context) {
            Preconditions.checkState((boolean)node.getOutputVariables().stream().noneMatch(x -> CheckNoTimestampWithTimezoneType.hasTimestampWithTimezoneType(x.getType())), (Object)CheckNoTimestampWithTimezoneType.errorMessage);
            return super.visitPlan(node, context);
        }

        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getAggregations().forEach((variable, aggregation) -> {
                aggregation.getCall().accept((RowExpressionVisitor)this.noTimeStampWithTimeZoneTypeChecker, null);
                if (aggregation.getFilter().isPresent()) {
                    ((RowExpression)aggregation.getFilter().get()).accept((RowExpressionVisitor)this.noTimeStampWithTimeZoneTypeChecker, null);
                }
            });
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getWindowFunctions().forEach((variable, function) -> function.getFunctionCall().accept((RowExpressionVisitor)this.noTimeStampWithTimeZoneTypeChecker, null));
            return null;
        }

        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getAssignments().getMap().forEach((variable, expression) -> expression.accept((RowExpressionVisitor)this.noTimeStampWithTimeZoneTypeChecker, null));
            return null;
        }

        public Void visitValues(ValuesNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (List row : node.getRows()) {
                row.forEach(x -> {
                    Void cfr_ignored_0 = (Void)x.accept((RowExpressionVisitor)this.noTimeStampWithTimeZoneTypeChecker, null);
                });
            }
            return null;
        }

        public Void visitFilter(FilterNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            node.getPredicate().accept((RowExpressionVisitor)this.noTimeStampWithTimeZoneTypeChecker, null);
            return null;
        }
    }
}

