/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.operator.DynamicFilterStats;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.planner.planPrinter.OperatorInputStats;
import com.facebook.presto.util.Mergeable;
import com.facebook.presto.util.MoreMaps;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PlanNodeStats
implements Mergeable<PlanNodeStats> {
    private final PlanNodeId planNodeId;
    private final Duration planNodeScheduledTime;
    private final Duration planNodeCpuTime;
    private final Duration planNodeBlockedWallTime;
    private final Duration planNodeAddInputWallTime;
    private final Duration planNodeGetOutputWallTime;
    private final Duration planNodeFinishWallTime;
    private final long planNodeInputPositions;
    private final DataSize planNodeInputDataSize;
    private final long planNodeRawInputPositions;
    private final DataSize planNodeRawInputDataSize;
    private final long planNodeOutputPositions;
    private final DataSize planNodeOutputDataSize;
    private final DataSize planNodePeakMemorySize;
    protected final Map<String, OperatorInputStats> operatorInputStats;
    private final long planNodeNullJoinBuildKeyCount;
    private final long planNodeJoinBuildKeyCount;
    private final long planNodeNullJoinProbeKeyCount;
    private final long planNodeJoinProbeKeyCount;
    private final Optional<DynamicFilterStats> dynamicFilterStats;

    @JsonCreator
    public PlanNodeStats(@JsonProperty(value="planNodeId") PlanNodeId planNodeId, @JsonProperty(value="planNodeScheduledTime") Duration planNodeScheduledTime, @JsonProperty(value="planNodeCpuTime") Duration planNodeCpuTime, @JsonProperty(value="planNodeBlockedWallTime") Duration planNodeBlockedWallTime, @JsonProperty(value="planNodeAddInputWallTime") Duration planNodeAddInputWallTime, @JsonProperty(value="planNodeGetOutputWallTime") Duration planNodeGetOutputWallTime, @JsonProperty(value="planNodeFinishWallTime") Duration planNodeFinishWallTime, @JsonProperty(value="planNodeInputPositions") long planNodeInputPositions, @JsonProperty(value="planNodeInputDataSize") DataSize planNodeInputDataSize, @JsonProperty(value="planNodeRawInputPositions") long planNodeRawInputPositions, @JsonProperty(value="planNodeRawInputDataSize") DataSize planNodeRawInputDataSize, @JsonProperty(value="planNodeOutputPositions") long planNodeOutputPositions, @JsonProperty(value="planNodeOutputDataSize") DataSize planNodeOutputDataSize, @JsonProperty(value="planNodePeakMemorySize") DataSize planNodePeakMemorySize, @JsonProperty(value="operatorInputStats") Map<String, OperatorInputStats> operatorInputStats, @JsonProperty(value="planNodeNullJoinBuildKeyCount") long planNodeNullJoinBuildKeyCount, @JsonProperty(value="planNodeJoinBuildKeyCount") long planNodeJoinBuildKeyCount, @JsonProperty(value="planNodeNullJoinProbeKeyCount") long planNodeNullJoinProbeKeyCount, @JsonProperty(value="planNodeJoinProbeKeyCount") long planNodeJoinProbeKeyCount, @JsonProperty(value="dynamicFilterStats") Optional<DynamicFilterStats> dynamicFilterStats) {
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.planNodeScheduledTime = Objects.requireNonNull(planNodeScheduledTime, "planNodeScheduledTime is null");
        this.planNodeCpuTime = Objects.requireNonNull(planNodeCpuTime, "planNodeCpuTime is null");
        this.planNodeBlockedWallTime = Objects.requireNonNull(planNodeBlockedWallTime, "planNodeBlockedWallTime is null");
        this.planNodeAddInputWallTime = Objects.requireNonNull(planNodeAddInputWallTime, "planNodeAddInputWallTime is null");
        this.planNodeGetOutputWallTime = Objects.requireNonNull(planNodeGetOutputWallTime, "planNodeGetOutputWallTime is null");
        this.planNodeFinishWallTime = Objects.requireNonNull(planNodeFinishWallTime, "planNodeFinishWallTime is null");
        this.planNodeInputPositions = planNodeInputPositions;
        this.planNodeInputDataSize = planNodeInputDataSize;
        this.planNodeRawInputPositions = planNodeRawInputPositions;
        this.planNodeRawInputDataSize = planNodeRawInputDataSize;
        this.planNodeOutputPositions = planNodeOutputPositions;
        this.planNodeOutputDataSize = planNodeOutputDataSize;
        this.operatorInputStats = Objects.requireNonNull(operatorInputStats, "operatorInputStats is null");
        this.planNodePeakMemorySize = planNodePeakMemorySize;
        this.planNodeNullJoinBuildKeyCount = planNodeNullJoinBuildKeyCount;
        this.planNodeJoinBuildKeyCount = planNodeJoinBuildKeyCount;
        this.planNodeNullJoinProbeKeyCount = planNodeNullJoinProbeKeyCount;
        this.planNodeJoinProbeKeyCount = planNodeJoinProbeKeyCount;
        this.dynamicFilterStats = dynamicFilterStats;
    }

    private static double computedStdDev(double sumSquared, double sum, long n) {
        double average = sum / (double)n;
        double variance = (sumSquared - 2.0 * sum * average + average * average * (double)n) / (double)n;
        return Math.sqrt(Double.max(variance, 0.0));
    }

    @JsonProperty
    public PlanNodeId getPlanNodeId() {
        return this.planNodeId;
    }

    @JsonProperty
    public Duration getPlanNodeScheduledTime() {
        return this.planNodeScheduledTime;
    }

    @JsonProperty
    public Duration getPlanNodeCpuTime() {
        return this.planNodeCpuTime;
    }

    @JsonProperty
    public Duration getPlanNodeBlockedWallTime() {
        return this.planNodeBlockedWallTime;
    }

    @JsonProperty
    public Duration getPlanNodeAddInputWallTime() {
        return this.planNodeAddInputWallTime;
    }

    @JsonProperty
    public Duration getPlanNodeGetOutputWallTime() {
        return this.planNodeGetOutputWallTime;
    }

    @JsonProperty
    public Duration getPlanNodeFinishWallTime() {
        return this.planNodeFinishWallTime;
    }

    @JsonProperty
    public Map<String, OperatorInputStats> getOperatorInputStats() {
        return Collections.unmodifiableMap(this.operatorInputStats);
    }

    public Set<String> getOperatorTypes() {
        return this.operatorInputStats.keySet();
    }

    @JsonProperty
    public long getPlanNodeInputPositions() {
        return this.planNodeInputPositions;
    }

    @JsonProperty
    public DataSize getPlanNodeInputDataSize() {
        return this.planNodeInputDataSize;
    }

    @JsonProperty
    public long getPlanNodeRawInputPositions() {
        return this.planNodeRawInputPositions;
    }

    @JsonProperty
    public DataSize getPlanNodeRawInputDataSize() {
        return this.planNodeRawInputDataSize;
    }

    @JsonProperty
    public long getPlanNodeOutputPositions() {
        return this.planNodeOutputPositions;
    }

    @JsonProperty
    public DataSize getPlanNodeOutputDataSize() {
        return this.planNodeOutputDataSize;
    }

    public Map<String, Double> getOperatorInputPositionsAverages() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (double)((OperatorInputStats)entry.getValue()).getInputPositions() / (double)this.operatorInputStats.get(entry.getKey()).getTotalDrivers()));
    }

    public Map<String, Double> getOperatorInputPositionsStdDevs() {
        return this.operatorInputStats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> PlanNodeStats.computedStdDev(((OperatorInputStats)entry.getValue()).getSumSquaredInputPositions(), ((OperatorInputStats)entry.getValue()).getInputPositions(), ((OperatorInputStats)entry.getValue()).getTotalDrivers())));
    }

    @JsonProperty
    public DataSize getPlanNodePeakMemorySize() {
        return this.planNodePeakMemorySize;
    }

    @JsonProperty
    public long getPlanNodeNullJoinBuildKeyCount() {
        return this.planNodeNullJoinBuildKeyCount;
    }

    @JsonProperty
    public long getPlanNodeJoinBuildKeyCount() {
        return this.planNodeJoinBuildKeyCount;
    }

    @JsonProperty
    public long getPlanNodeNullJoinProbeKeyCount() {
        return this.planNodeNullJoinProbeKeyCount;
    }

    @JsonProperty
    public long getPlanNodeJoinProbeKeyCount() {
        return this.planNodeJoinProbeKeyCount;
    }

    public Optional<DynamicFilterStats> getDynamicFilterStats() {
        return this.dynamicFilterStats;
    }

    public static Optional<DynamicFilterStats> mergeDynamicFilterStats(Optional<DynamicFilterStats> stats1, Optional<DynamicFilterStats> stats2) {
        Optional<DynamicFilterStats> optionalDynamicFilterStats = Optional.empty();
        if (stats1.isPresent()) {
            DynamicFilterStats dynamicFilterStats = stats1.get();
            stats2.ifPresent(dynamicFilterStats::mergeWith);
            optionalDynamicFilterStats = Optional.of(dynamicFilterStats);
        } else if (stats2.isPresent()) {
            optionalDynamicFilterStats = Optional.of(stats2.get());
        }
        return optionalDynamicFilterStats;
    }

    @Override
    public PlanNodeStats mergeWith(PlanNodeStats other) {
        Preconditions.checkArgument((boolean)this.planNodeId.equals((Object)other.getPlanNodeId()), (String)"planNodeIds do not match. %s != %s", (Object)this.planNodeId, (Object)other.getPlanNodeId());
        long planNodeInputPositions = this.planNodeInputPositions + other.planNodeInputPositions;
        DataSize planNodeInputDataSize = DataSize.succinctBytes((long)((long)((double)this.planNodeInputDataSize.toBytes() + (double)other.planNodeInputDataSize.toBytes())));
        long planNodeRawInputPositions = this.planNodeRawInputPositions + other.planNodeRawInputPositions;
        DataSize planNodeRawInputDataSize = DataSize.succinctBytes((long)((long)((double)this.planNodeRawInputDataSize.toBytes() + (double)other.planNodeRawInputDataSize.toBytes())));
        long planNodeOutputPositions = this.planNodeOutputPositions + other.planNodeOutputPositions;
        DataSize planNodeOutputDataSize = DataSize.succinctBytes((long)((long)((double)this.planNodeOutputDataSize.toBytes() + (double)other.planNodeOutputDataSize.toBytes())));
        DataSize planNodePeakMemorySize = DataSize.succinctBytes((long)Math.max(this.planNodePeakMemorySize.toBytes(), other.planNodePeakMemorySize.toBytes()));
        Map<String, OperatorInputStats> operatorInputStats = MoreMaps.mergeMaps(this.operatorInputStats, other.operatorInputStats, OperatorInputStats::merge);
        long planNodeNullJoinBuildKeyCount = this.planNodeNullJoinBuildKeyCount + other.planNodeNullJoinBuildKeyCount;
        long planNodeJoinBuildKeyCount = this.planNodeJoinBuildKeyCount + other.planNodeJoinBuildKeyCount;
        long planNodeNullJoinProbeKeyCount = this.planNodeNullJoinProbeKeyCount + other.planNodeNullJoinProbeKeyCount;
        long planNodeJoinProbeKeyCount = this.planNodeJoinProbeKeyCount + other.planNodeJoinProbeKeyCount;
        Optional<DynamicFilterStats> optionalDynamicFilterStats = PlanNodeStats.mergeDynamicFilterStats(this.dynamicFilterStats, other.dynamicFilterStats);
        return new PlanNodeStats(this.planNodeId, new Duration((double)(this.planNodeScheduledTime.toMillis() + other.getPlanNodeScheduledTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeCpuTime.toMillis() + other.getPlanNodeCpuTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeBlockedWallTime.toMillis() + other.getPlanNodeBlockedWallTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeAddInputWallTime.toMillis() + other.getPlanNodeAddInputWallTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeGetOutputWallTime.toMillis() + other.getPlanNodeGetOutputWallTime().toMillis()), TimeUnit.MILLISECONDS), new Duration((double)(this.planNodeFinishWallTime.toMillis() + other.getPlanNodeFinishWallTime().toMillis()), TimeUnit.MILLISECONDS), planNodeInputPositions, planNodeInputDataSize, planNodeRawInputPositions, planNodeRawInputDataSize, planNodeOutputPositions, planNodeOutputDataSize, planNodePeakMemorySize, operatorInputStats, planNodeNullJoinBuildKeyCount, planNodeJoinBuildKeyCount, planNodeNullJoinProbeKeyCount, planNodeJoinProbeKeyCount, optionalDynamicFilterStats);
    }
}

