/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizerResult;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class JoinPrefilter
implements PlanOptimizer {
    private final Metadata metadata;
    private boolean isEnabledForTesting;

    public JoinPrefilter(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public void setEnabledForTesting(boolean isSet) {
        this.isEnabledForTesting = isSet;
    }

    @Override
    public boolean isEnabled(Session session) {
        return this.isEnabledForTesting || SystemSessionProperties.isJoinPrefilterEnabled(session);
    }

    @Override
    public PlanOptimizerResult optimize(PlanNode plan, Session session, TypeProvider types, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (this.isEnabled(session)) {
            Rewriter rewriter = new Rewriter(session, this.metadata, idAllocator, variableAllocator);
            PlanNode rewritten = SimplePlanRewriter.rewriteWith(rewriter, plan, null);
            return PlanOptimizerResult.optimizerResult(rewritten, rewriter.isPlanChanged());
        }
        return PlanOptimizerResult.optimizerResult(plan, false);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Session session;
        private final Metadata metadata;
        private final PlanNodeIdAllocator idAllocator;
        private final VariableAllocator variableAllocator;
        private boolean planChanged;

        private Rewriter(Session session, Metadata metadata, PlanNodeIdAllocator idAllocator, VariableAllocator variableAllocator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "functionAndTypeManager is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitJoin(JoinNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode left = node.getLeft();
            PlanNode right = node.getRight();
            PlanNode rewrittenLeft = Rewriter.rewriteWith(this, left);
            PlanNode rewrittenRight = Rewriter.rewriteWith(this, right);
            List<EquiJoinClause> equiJoinClause = node.getCriteria();
            if (equiJoinClause.size() == 1 && (node.getType() == JoinType.LEFT || node.getType() == JoinType.INNER) && PlannerUtils.isScanFilterProject(rewrittenLeft)) {
                VariableReferenceExpression leftKey = equiJoinClause.stream().map(x -> x.getLeft()).findFirst().get();
                VariableReferenceExpression rightKey = equiJoinClause.stream().map(x -> x.getRight()).findFirst().get();
                HashMap<VariableReferenceExpression, VariableReferenceExpression> leftVarMap = new HashMap<VariableReferenceExpression, VariableReferenceExpression>();
                PlanNode leftKeys = PlannerUtils.clonePlanNode(rewrittenLeft, this.session, this.metadata, this.idAllocator, (List<VariableReferenceExpression>)ImmutableList.of((Object)leftKey), leftVarMap);
                PlanNode projectNode = PlannerUtils.projectExpressions(leftKeys, this.idAllocator, this.variableAllocator, (List<? extends RowExpression>)ImmutableList.of(leftVarMap.get(leftKey)), (List<VariableReferenceExpression>)ImmutableList.of());
                AggregationNode filteringSource = new AggregationNode(leftKey.getSourceLocation(), this.idAllocator.getNextId(), projectNode, (Map)ImmutableMap.of(), AggregationNode.singleGroupingSet((List)projectNode.getOutputVariables()), projectNode.getOutputVariables(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty());
                filteringSource = PlannerUtils.projectExpressions((PlanNode)filteringSource, this.idAllocator, this.variableAllocator, (List<? extends RowExpression>)ImmutableList.of(filteringSource.getOutputVariables().get(0)), (List<VariableReferenceExpression>)ImmutableList.of());
                VariableReferenceExpression semiJoinOutput = this.variableAllocator.newVariable("semiJoinOutput", (Type)BooleanType.BOOLEAN);
                SemiJoinNode semiJoinNode = new SemiJoinNode(rightKey.getSourceLocation(), this.idAllocator.getNextId(), node.getStatsEquivalentPlanNode(), rewrittenRight, (PlanNode)filteringSource, rightKey, (VariableReferenceExpression)filteringSource.getOutputVariables().get(0), semiJoinOutput, Optional.empty(), Optional.empty(), Optional.empty(), (Map<String, VariableReferenceExpression>)ImmutableMap.of());
                rewrittenRight = new FilterNode(semiJoinNode.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)semiJoinNode, (RowExpression)semiJoinOutput);
            }
            if (rewrittenLeft != node.getLeft() || rewrittenRight != node.getRight()) {
                this.planChanged = true;
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)rewrittenLeft, (Object)rewrittenRight));
            }
            return node;
        }

        public boolean isPlanChanged() {
            return this.planChanged;
        }
    }
}

