/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Capture;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SimplifyCountOverConstant
implements Rule<AggregationNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final StandardFunctionResolution functionResolution;

    public SimplifyCountOverConstant(FunctionAndTypeManager functionAndTypeManager) {
        Objects.requireNonNull(functionAndTypeManager, "functionManager is null");
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = (ProjectNode)captures.get(CHILD);
        boolean changed = false;
        LinkedHashMap<VariableReferenceExpression, AggregationNode.Aggregation> aggregations = new LinkedHashMap<VariableReferenceExpression, AggregationNode.Aggregation>(parent.getAggregations());
        for (Map.Entry entry : parent.getAggregations().entrySet()) {
            VariableReferenceExpression variable = (VariableReferenceExpression)entry.getKey();
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)entry.getValue();
            if (!this.isCountOverConstant(aggregation, child.getAssignments())) continue;
            changed = true;
            aggregations.put(variable, new AggregationNode.Aggregation(new CallExpression(aggregation.getCall().getSourceLocation(), "count", this.functionResolution.countFunction(), (Type)BigintType.BIGINT, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), false, aggregation.getMask()));
        }
        if (!changed) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode((PlanNode)new AggregationNode(parent.getSourceLocation(), parent.getId(), (PlanNode)child, aggregations, parent.getGroupingSets(), (List)ImmutableList.of(), parent.getStep(), parent.getHashVariable(), parent.getGroupIdVariable(), parent.getAggregationId()));
    }

    private boolean isCountOverConstant(AggregationNode.Aggregation aggregation, Assignments inputs) {
        if (!this.functionResolution.isCountFunction(aggregation.getFunctionHandle()) || aggregation.getArguments().size() != 1) {
            return false;
        }
        RowExpression argument = (RowExpression)aggregation.getArguments().get(0);
        RowExpression assigned = null;
        if (argument instanceof VariableReferenceExpression) {
            assigned = inputs.get((VariableReferenceExpression)argument);
        }
        return assigned instanceof ConstantExpression && !Expressions.isNull(assigned);
    }
}

