/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.expressions.LogicalRowExpressions;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;

public class RemoveTrivialFilters
implements Rule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        RowExpression predicate = filterNode.getPredicate();
        if (predicate.equals((Object)LogicalRowExpressions.TRUE_CONSTANT)) {
            return Rule.Result.ofPlanNode(filterNode.getSource());
        }
        if (predicate.equals((Object)LogicalRowExpressions.FALSE_CONSTANT)) {
            return Rule.Result.ofPlanNode((PlanNode)new ValuesNode(filterNode.getSourceLocation(), context.getIdAllocator().getNextId(), filterNode.getOutputVariables(), (List)ImmutableList.of(), Optional.empty()));
        }
        return Rule.Result.empty();
    }
}

