/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.spi.plan.TopNNode;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;

public class RemoveRedundantTopN
implements Rule<TopNNode> {
    private static final Pattern<TopNNode> PATTERN = Patterns.topN().matching(RemoveRedundantTopN::singleRowInput);

    private static boolean singleRowInput(TopNNode node) {
        return node.getStep() == TopNNode.Step.SINGLE && ((GroupReference)node.getSource()).getLogicalProperties().isPresent() && ((GroupReference)node.getSource()).getLogicalProperties().get().isAtMostSingleRow();
    }

    @Override
    public Pattern<TopNNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TopNNode node, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(node.getSource());
    }
}

