/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.spi.function.StandardFunctionResolution;
import com.facebook.presto.spi.plan.FilterNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.FunctionResolution;
import java.util.Objects;

public class ImplementBernoulliSampleAsFilter
implements Rule<SampleNode> {
    private static final Pattern<SampleNode> PATTERN = Patterns.sample().with(Patterns.Sample.sampleType().equalTo((Object)SampleNode.Type.BERNOULLI));
    private final FunctionAndTypeManager functionAndTypeManager;
    private final StandardFunctionResolution functionResolution;

    public ImplementBernoulliSampleAsFilter(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "functionAndTypeManager is null");
        this.functionResolution = new FunctionResolution(functionAndTypeManager.getFunctionAndTypeResolver());
    }

    @Override
    public Pattern<SampleNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(SampleNode sample, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode((PlanNode)new FilterNode(sample.getSourceLocation(), sample.getId(), sample.getSource(), Expressions.comparisonExpression(this.functionResolution, OperatorType.LESS_THAN, (RowExpression)Expressions.call(this.functionAndTypeManager, "rand", (Type)DoubleType.DOUBLE, new RowExpression[0]), (RowExpression)new ConstantExpression((Object)sample.getSampleRatio(), (Type)DoubleType.DOUBLE))));
    }
}

