/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.properties;

import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.iterative.properties.EquivalenceClassProperty;
import com.facebook.presto.sql.planner.iterative.properties.LogicalPropertiesImpl;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class Key {
    private final Set<VariableReferenceExpression> variables;

    public Key(Set<VariableReferenceExpression> variables) {
        Objects.requireNonNull(variables, "Variables is null.");
        Preconditions.checkArgument((!variables.isEmpty() ? 1 : 0) != 0, (Object)"Variables is empty");
        this.variables = ImmutableSet.copyOf(variables);
    }

    public boolean keySatisifiesRequirement(Key keyRequirement) {
        return this.variables.stream().allMatch(vk -> keyRequirement.variables.stream().anyMatch(arg_0 -> ((VariableReferenceExpression)vk).equals(arg_0)));
    }

    public static Optional<Key> getNormalizedKey(Key key, EquivalenceClassProperty equivalenceClassProperty) {
        Set unboundVariables = (Set)key.variables.stream().map(v -> equivalenceClassProperty.getEquivalenceClassHead((RowExpression)v)).filter(equivalenceHead -> equivalenceHead instanceof VariableReferenceExpression).map(eqHead -> (VariableReferenceExpression)eqHead).collect(ImmutableSet.toImmutableSet());
        return unboundVariables.isEmpty() ? Optional.empty() : Optional.of(new Key(unboundVariables));
    }

    public Optional<Key> project(LogicalPropertiesImpl.InverseVariableMappingsWithEquivalence inverseVariableMappings) {
        HashSet<VariableReferenceExpression> mappedVariables = new HashSet<VariableReferenceExpression>();
        for (VariableReferenceExpression v : this.variables) {
            Optional<VariableReferenceExpression> mappedVariable = inverseVariableMappings.get(v);
            if (mappedVariable.isPresent()) {
                mappedVariables.add(mappedVariable.get());
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(new Key(mappedVariables));
    }

    public static Key concatKeys(Key thisKey, Key otherKey) {
        ImmutableSet.Builder concatenatedVariables = ImmutableSet.builder();
        concatenatedVariables.addAll(thisKey.variables).addAll(otherKey.variables);
        return new Key((Set<VariableReferenceExpression>)concatenatedVariables.build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("variables", (Object)this.variables.stream().map(VariableReferenceExpression::toString).collect(Collectors.joining(","))).toString();
    }
}

