/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.airlift.json.Codec;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.cost.StatsAndCosts;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Set<VariableReferenceExpression> variables;
    private final PartitioningHandle partitioning;
    private final List<PlanNodeId> tableScanSchedulingOrder;
    private final List<Type> types;
    private final List<RemoteSourceNode> remoteSourceNodes;
    private final PartitioningScheme partitioningScheme;
    private final StageExecutionDescriptor stageExecutionDescriptor;
    private final boolean outputTableWriterFragment;
    private final Optional<StatsAndCosts> statsAndCosts;
    private final Optional<String> jsonRepresentation;
    @GuardedBy(value="this")
    private byte[] cachedSerialization;
    @GuardedBy(value="this")
    private Codec<PlanFragment> lastUsedCodec;

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="variables") Set<VariableReferenceExpression> variables, @JsonProperty(value="partitioning") PartitioningHandle partitioning, @JsonProperty(value="tableScanSchedulingOrder") List<PlanNodeId> tableScanSchedulingOrder, @JsonProperty(value="partitioningScheme") PartitioningScheme partitioningScheme, @JsonProperty(value="stageExecutionDescriptor") StageExecutionDescriptor stageExecutionDescriptor, @JsonProperty(value="outputTableWriterFragment") boolean outputTableWriterFragment, @JsonProperty(value="statsAndCosts") Optional<StatsAndCosts> statsAndCosts, @JsonProperty(value="jsonRepresentation") Optional<String> jsonRepresentation) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.variables = Objects.requireNonNull(variables, "variables is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.tableScanSchedulingOrder = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableScanSchedulingOrder, "tableScanSchedulingOrder is null"));
        this.stageExecutionDescriptor = Objects.requireNonNull(stageExecutionDescriptor, "stageExecutionDescriptor is null");
        this.outputTableWriterFragment = outputTableWriterFragment;
        this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        this.jsonRepresentation = Objects.requireNonNull(jsonRepresentation, "jsonRepresentation is null");
        Preconditions.checkArgument((boolean)root.getOutputVariables().containsAll(partitioningScheme.getOutputLayout()), (String)"Root node outputs (%s) does not include all fragment outputs (%s)", (Object)root.getOutputVariables(), partitioningScheme.getOutputLayout());
        this.types = (List)partitioningScheme.getOutputLayout().stream().map(VariableReferenceExpression::getType).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder remoteSourceNodes = ImmutableList.builder();
        PlanFragment.findRemoteSourceNodes(root, (ImmutableList.Builder<RemoteSourceNode>)remoteSourceNodes);
        this.remoteSourceNodes = remoteSourceNodes.build();
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Set<VariableReferenceExpression> getVariables() {
        return this.variables;
    }

    @JsonProperty
    public PartitioningHandle getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<PlanNodeId> getTableScanSchedulingOrder() {
        return this.tableScanSchedulingOrder;
    }

    @JsonProperty
    public PartitioningScheme getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public StageExecutionDescriptor getStageExecutionDescriptor() {
        return this.stageExecutionDescriptor;
    }

    @JsonProperty
    public boolean isOutputTableWriterFragment() {
        return this.outputTableWriterFragment;
    }

    @JsonProperty
    public Optional<StatsAndCosts> getStatsAndCosts() {
        return this.statsAndCosts;
    }

    @JsonProperty
    public Optional<String> getJsonRepresentation() {
        return this.jsonRepresentation;
    }

    public synchronized byte[] bytesForTaskSerialization(Codec<PlanFragment> codec) {
        Objects.requireNonNull(codec, "codec is null");
        if (this.cachedSerialization != null) {
            Verify.verify((codec == this.lastUsedCodec ? 1 : 0) != 0, (String)"Only one Codec may be used to serialize PlanFragments", (Object[])new Object[0]);
        } else {
            this.cachedSerialization = codec.toBytes((Object)this.forTaskSerialization());
            this.lastUsedCodec = codec;
        }
        return this.cachedSerialization;
    }

    private PlanFragment forTaskSerialization() {
        return new PlanFragment(this.id, this.root, this.variables, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme, this.stageExecutionDescriptor, this.outputTableWriterFragment, Optional.empty(), Optional.empty());
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public boolean isLeaf() {
        return this.remoteSourceNodes.isEmpty();
    }

    public List<RemoteSourceNode> getRemoteSourceNodes() {
        return this.remoteSourceNodes;
    }

    private static Set<PlanNode> findSources(PlanNode node, Iterable<PlanNodeId> nodeIds) {
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        PlanFragment.findSources(node, (Set<PlanNodeId>)ImmutableSet.copyOf(nodeIds), (ImmutableSet.Builder<PlanNode>)nodes);
        return nodes.build();
    }

    private static void findSources(PlanNode node, Set<PlanNodeId> nodeIds, ImmutableSet.Builder<PlanNode> nodes) {
        if (nodeIds.contains(node.getId())) {
            nodes.add((Object)node);
        }
        for (PlanNode source : node.getSources()) {
            nodes.addAll(PlanFragment.findSources(source, nodeIds));
        }
    }

    private static void findRemoteSourceNodes(PlanNode node, ImmutableList.Builder<RemoteSourceNode> builder) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findRemoteSourceNodes(source, builder);
        }
        if (node instanceof RemoteSourceNode) {
            builder.add((Object)((RemoteSourceNode)node));
        }
    }

    public PlanFragment withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PlanFragment(this.id, this.root, this.variables, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme.withBucketToPartition(bucketToPartition), this.stageExecutionDescriptor, this.outputTableWriterFragment, this.statsAndCosts, this.jsonRepresentation);
    }

    public PlanFragment withFixedLifespanScheduleGroupedExecution(List<PlanNodeId> capableTableScanNodes, int totalLifespans) {
        return new PlanFragment(this.id, this.root, this.variables, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme, StageExecutionDescriptor.fixedLifespanScheduleGroupedExecution(capableTableScanNodes, totalLifespans), this.outputTableWriterFragment, this.statsAndCosts, this.jsonRepresentation);
    }

    public PlanFragment withDynamicLifespanScheduleGroupedExecution(List<PlanNodeId> capableTableScanNodes, int totalLifespans) {
        return new PlanFragment(this.id, this.root, this.variables, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme, StageExecutionDescriptor.dynamicLifespanScheduleGroupedExecution(capableTableScanNodes, totalLifespans), this.outputTableWriterFragment, this.statsAndCosts, this.jsonRepresentation);
    }

    public PlanFragment withRecoverableGroupedExecution(List<PlanNodeId> capableTableScanNodes, int totalLifespans) {
        return new PlanFragment(this.id, this.root, this.variables, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme, StageExecutionDescriptor.recoverableGroupedExecution(capableTableScanNodes, totalLifespans), this.outputTableWriterFragment, this.statsAndCosts, this.jsonRepresentation);
    }

    public PlanFragment withSubPlan(PlanNode subPlan) {
        return new PlanFragment(this.id, subPlan, this.variables, this.partitioning, this.tableScanSchedulingOrder, this.partitioningScheme, this.stageExecutionDescriptor, this.outputTableWriterFragment, this.statsAndCosts, this.jsonRepresentation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("partitioning", (Object)this.partitioning).add("tableScanSchedulingOrder", this.tableScanSchedulingOrder).add("partitionFunction", (Object)this.partitioningScheme).toString();
    }
}

