/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.gen.SpecialFormBytecodeGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;

public class AndCodeGenerator
implements SpecialFormBytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator, Type returnType, List<RowExpression> arguments, Optional<Variable> outputBlockVariable) {
        Preconditions.checkArgument((arguments.size() == 2 ? 1 : 0) != 0);
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.push(arguments.get(1));
        stack.push(arguments.get(0));
        ImmutableList.Builder flattenedArgs = ImmutableList.builder();
        do {
            RowExpression operand;
            if ((operand = (RowExpression)stack.pop()) instanceof SpecialFormExpression && ((SpecialFormExpression)operand).getForm() == SpecialFormExpression.Form.AND) {
                stack.push(((SpecialFormExpression)operand).getArguments().get(1));
                stack.push(((SpecialFormExpression)operand).getArguments().get(0));
                continue;
            }
            flattenedArgs.add((Object)operand);
        } while (!stack.isEmpty());
        BytecodeBlock block = new BytecodeBlock().comment("AND").setDescription("AND");
        LabelNode falseLabel = new LabelNode("false");
        LabelNode endLabel = new LabelNode("end");
        Variable wasNull = generator.wasNull();
        Variable hasNulls = generator.getScope().createTempVariable(Boolean.TYPE);
        block.initializeVariable(hasNulls);
        for (RowExpression expression : flattenedArgs.build()) {
            block.comment("do { eval arg; if (wasNull) { hasNull = true; wasNull = false; } else if (false) goto ret_false; }").append(generator.generate(expression, Optional.empty()));
            IfStatement ifOperandIsNull = new IfStatement("if left wasNull...", new Object[0]).condition((BytecodeNode)wasNull);
            ifOperandIsNull.ifTrue().comment("clear the null flag and remember there was a null").putVariable(hasNulls, true).putVariable(wasNull, false).pop(Boolean.TYPE);
            ifOperandIsNull.ifFalse().ifFalseGoto(falseLabel);
            block.append((BytecodeNode)ifOperandIsNull);
        }
        IfStatement ifHasNulls = new IfStatement("hasNulls is true", new Object[0]);
        ifHasNulls.condition().append((BytecodeNode)hasNulls);
        ifHasNulls.ifTrue().comment("at least one of the arguments is null and none of them is false. So set wasNull to true").putVariable(wasNull, true).push(false);
        ifHasNulls.ifFalse().push(true);
        block.append((BytecodeNode)ifHasNulls).gotoLabel(endLabel);
        block.visitLabel(falseLabel).comment("at least one of the args is false, clear wasNull and return false").push(false).gotoLabel(endLabel);
        block.visitLabel(endLabel);
        outputBlockVariable.ifPresent(output -> block.append(SpecialFormBytecodeGenerator.generateWrite(generator, returnType, output)));
        return block;
    }
}

