/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.analyzer.QueryPreparerProvider;
import com.facebook.presto.sql.analyzer.BuiltInQueryPreparerProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class QueryPreparerProviderManager {
    private final Map<String, QueryPreparerProvider> queryPreparerProviders = new HashMap<String, QueryPreparerProvider>();

    @Inject
    public QueryPreparerProviderManager(BuiltInQueryPreparerProvider queryPreparerProvider) {
        this.addQueryPreparerProvider(queryPreparerProvider);
    }

    public void addQueryPreparerProvider(QueryPreparerProvider preparerProvider) {
        Objects.requireNonNull(preparerProvider, "preparerProvider is null");
        if (this.queryPreparerProviders.putIfAbsent(preparerProvider.getType(), preparerProvider) != null) {
            throw new IllegalArgumentException(String.format("Query preparer provider '%s' is already registered", preparerProvider.getType()));
        }
    }

    public QueryPreparerProvider getQueryPreparerProvider(String preparerType) {
        if (this.queryPreparerProviders.containsKey(preparerType)) {
            return this.queryPreparerProviders.get(preparerType);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_ANALYZER_TYPE, "Unsupported query preparer type: " + preparerType);
    }
}

