/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.common.InvalidFunctionArgumentException;
import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.TimeZoneNotSupportedException;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.JavaScalarFunctionImplementation;
import com.facebook.presto.sql.gen.BytecodeUtils;
import com.google.common.base.Defaults;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class InterpretedFunctionInvoker {
    private final FunctionAndTypeManager functionAndTypeManager;

    public InterpretedFunctionInvoker(FunctionAndTypeManager functionAndTypeManager) {
        this.functionAndTypeManager = Objects.requireNonNull(functionAndTypeManager, "registry is null");
    }

    public Object invoke(FunctionHandle functionHandle, SqlFunctionProperties properties, Object ... arguments) {
        return this.invoke(functionHandle, properties, Arrays.asList(arguments));
    }

    public Object invoke(FunctionHandle functionHandle, SqlFunctionProperties properties, List<Object> arguments) {
        return this.invoke(this.functionAndTypeManager.getJavaScalarFunctionImplementation(functionHandle), properties, arguments);
    }

    private Object invoke(JavaScalarFunctionImplementation function, SqlFunctionProperties properties, List<Object> arguments) {
        ScalarFunctionImplementationChoice choice = BytecodeUtils.getAllScalarFunctionImplementationChoices(function).get(0);
        MethodHandle method = choice.getMethodHandle();
        if ((method = InterpretedFunctionInvoker.bindInstanceFactory(method, function)).type().parameterCount() > 0 && method.type().parameterType(0) == SqlFunctionProperties.class) {
            method = method.bindTo(properties);
        }
        ArrayList<Object> actualArguments = new ArrayList<Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            Object argument = arguments.get(i);
            ScalarFunctionImplementationChoice.ArgumentProperty argumentProperty = choice.getArgumentProperty(i);
            if (argumentProperty.getArgumentType() == ScalarFunctionImplementationChoice.ArgumentType.VALUE_TYPE) {
                if (choice.getArgumentProperty(i).getNullConvention() == ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL) {
                    if (argument == null) {
                        return null;
                    }
                    actualArguments.add(argument);
                    continue;
                }
                if (choice.getArgumentProperty(i).getNullConvention() == ScalarFunctionImplementationChoice.NullConvention.USE_NULL_FLAG) {
                    boolean isNull;
                    boolean bl = isNull = argument == null;
                    if (isNull) {
                        argument = Defaults.defaultValue((Class)method.type().parameterType(actualArguments.size()));
                    }
                    actualArguments.add(argument);
                    actualArguments.add(isNull);
                    continue;
                }
                actualArguments.add(argument);
                continue;
            }
            argument = MethodHandleProxies.asInterfaceInstance(argumentProperty.getLambdaInterface(), (MethodHandle)argument);
            actualArguments.add(argument);
        }
        try {
            return method.invokeWithArguments(actualArguments);
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static MethodHandle bindInstanceFactory(MethodHandle method, JavaScalarFunctionImplementation implementation) {
        if (!(implementation instanceof BuiltInScalarFunctionImplementation)) {
            return method;
        }
        BuiltInScalarFunctionImplementation builtInImplementation = (BuiltInScalarFunctionImplementation)implementation;
        if (!builtInImplementation.getInstanceFactory().isPresent()) {
            return method;
        }
        try {
            return method.bindTo(builtInImplementation.getInstanceFactory().get().invoke());
        }
        catch (Throwable throwable) {
            throw InterpretedFunctionInvoker.propagate(throwable);
        }
    }

    private static RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (throwable instanceof InvalidFunctionArgumentException) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, throwable.getMessage(), throwable);
        }
        if (throwable instanceof NotSupportedException || throwable instanceof TimeZoneNotSupportedException) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, throwable.getMessage(), throwable);
        }
        Throwables.throwIfUnchecked((Throwable)throwable);
        throw new RuntimeException(throwable);
    }
}

