/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.smile;

import com.facebook.airlift.http.client.HeaderName;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.Response;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.ResponseHandlerUtils;
import com.facebook.airlift.json.smile.SmileCodec;
import com.facebook.presto.server.smile.BaseResponse;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;

public class FullSmileResponseHandler<T>
implements ResponseHandler<SmileResponse<T>, RuntimeException> {
    private static final MediaType MEDIA_TYPE_SMILE = MediaType.create((String)"application", (String)"x-jackson-smile");
    private final SmileCodec<T> smileCodec;

    public static <T> FullSmileResponseHandler<T> createFullSmileResponseHandler(SmileCodec<T> smileCodec) {
        return new FullSmileResponseHandler<T>(smileCodec);
    }

    private FullSmileResponseHandler(SmileCodec<T> smileCodec) {
        this.smileCodec = smileCodec;
    }

    public SmileResponse<T> handleException(Request request, Exception exception) {
        throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
    }

    public SmileResponse<T> handle(Request request, Response response) {
        byte[] bytes = FullSmileResponseHandler.readResponseBytes(response);
        String contentType = response.getHeader("Content-Type");
        if (contentType == null || !MediaType.parse((String)contentType).is(MEDIA_TYPE_SMILE)) {
            return new SmileResponse(response.getStatusCode(), (ListMultimap<HeaderName, String>)response.getHeaders(), bytes);
        }
        return new SmileResponse<T>(response.getStatusCode(), (ListMultimap<HeaderName, String>)response.getHeaders(), this.smileCodec, bytes);
    }

    private static byte[] readResponseBytes(Response response) {
        try {
            return ByteStreams.toByteArray((InputStream)response.getInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error reading response from server", e);
        }
    }

    public static class SmileResponse<T>
    implements BaseResponse<T> {
        private final int statusCode;
        private final ListMultimap<HeaderName, String> headers;
        private final boolean hasValue;
        private final byte[] smileBytes;
        private final byte[] responseBytes;
        private final T value;
        private final IllegalArgumentException exception;

        public SmileResponse(int statusCode, ListMultimap<HeaderName, String> headers, byte[] responseBytes) {
            this.statusCode = statusCode;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.hasValue = false;
            this.smileBytes = null;
            this.responseBytes = Objects.requireNonNull(responseBytes, "responseBytes is null");
            this.value = null;
            this.exception = null;
        }

        public SmileResponse(int statusCode, ListMultimap<HeaderName, String> headers, SmileCodec<T> smileCodec, byte[] smileBytes) {
            this.statusCode = statusCode;
            this.headers = ImmutableListMultimap.copyOf(headers);
            this.smileBytes = Objects.requireNonNull(smileBytes, "smileBytes is null");
            this.responseBytes = smileBytes;
            Object value = null;
            IllegalArgumentException exception = null;
            try {
                value = smileCodec.fromSmile(smileBytes);
            }
            catch (IllegalArgumentException e) {
                exception = new IllegalArgumentException("Unable to create " + smileCodec.getType() + " from SMILE response", e);
            }
            this.hasValue = exception == null;
            this.value = value;
            this.exception = exception;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public String getHeader(String name) {
            List values = this.getHeaders().get((Object)HeaderName.of((String)name));
            if (values.isEmpty()) {
                return null;
            }
            return (String)values.get(0);
        }

        @Override
        public List<String> getHeaders(String name) {
            return this.headers.get((Object)HeaderName.of((String)name));
        }

        @Override
        public ListMultimap<HeaderName, String> getHeaders() {
            return this.headers;
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public T getValue() {
            if (!this.hasValue) {
                throw new IllegalStateException("Response does not contain a SMILE value", this.exception);
            }
            return this.value;
        }

        public byte[] getSmileBytes() {
            return this.smileBytes == null ? null : (byte[])this.smileBytes.clone();
        }

        @Override
        public int getResponseSize() {
            return this.responseBytes.length;
        }

        @Override
        public byte[] getResponseBytes() {
            return (byte[])this.responseBytes.clone();
        }

        @Override
        public IllegalArgumentException getException() {
            return this.exception;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("statusCode", this.statusCode).add("headers", this.headers).add("hasValue", this.hasValue).add("value", this.value).toString();
        }
    }
}

