/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.airlift.configuration.DefunctConfig;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.List;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"http.server.authentication.enabled"})
public class SecurityConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private List<AuthenticationType> authenticationTypes = ImmutableList.of();
    private boolean allowForwardedHttps;
    private boolean authorizedIdentitySelectionEnabled;

    @NotNull
    public List<AuthenticationType> getAuthenticationTypes() {
        return this.authenticationTypes;
    }

    public SecurityConfig setAuthenticationTypes(List<AuthenticationType> authenticationTypes) {
        this.authenticationTypes = ImmutableList.copyOf(authenticationTypes);
        return this;
    }

    @Config(value="http-server.authentication.type")
    @ConfigDescription(value="Authentication types (supported types: CERTIFICATE, KERBEROS, PASSWORD, JWT)")
    public SecurityConfig setAuthenticationTypes(String types) {
        if (types == null) {
            this.authenticationTypes = null;
            return this;
        }
        this.authenticationTypes = (List)Streams.stream((Iterable)SPLITTER.split((CharSequence)types)).map(AuthenticationType::valueOf).collect(ImmutableList.toImmutableList());
        return this;
    }

    public boolean getAllowForwardedHttps() {
        return this.allowForwardedHttps;
    }

    @Config(value="http-server.authentication.allow-forwarded-https")
    @ConfigDescription(value="Allow forwarded HTTPS requests")
    public SecurityConfig setAllowForwardedHttps(boolean allowForwardedHttps) {
        this.allowForwardedHttps = allowForwardedHttps;
        return this;
    }

    @Config(value="permissions.authorized-identity-selection-enabled")
    @ConfigDescription(value="Authorized identity selection enabled")
    public SecurityConfig setAuthorizedIdentitySelectionEnabled(boolean authorizedIdentitySelectionEnabled) {
        this.authorizedIdentitySelectionEnabled = authorizedIdentitySelectionEnabled;
        return this;
    }

    public boolean isAuthorizedIdentitySelectionEnabled() {
        return this.authorizedIdentitySelectionEnabled;
    }

    public static enum AuthenticationType {
        CERTIFICATE,
        KERBEROS,
        PASSWORD,
        JWT;

    }
}

