/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.security;

import com.facebook.airlift.http.server.AuthenticationException;
import com.facebook.airlift.http.server.Authenticator;
import com.facebook.presto.server.security.SecurityConfig;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
implements Filter {
    private static final String HTTPS_PROTOCOL = "https";
    private final List<Authenticator> authenticators;
    private final boolean allowForwardedHttps;

    @Inject
    public AuthenticationFilter(List<Authenticator> authenticators, SecurityConfig securityConfig) {
        this.authenticators = ImmutableList.copyOf((Collection)Objects.requireNonNull(authenticators, "authenticators is null"));
        this.allowForwardedHttps = Objects.requireNonNull(securityConfig, "securityConfig is null").getAllowForwardedHttps();
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain nextFilter) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!this.doesRequestSupportAuthentication(request)) {
            nextFilter.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        LinkedHashSet authenticateHeaders = new LinkedHashSet();
        for (Authenticator authenticator : this.authenticators) {
            Principal principal;
            try {
                principal = authenticator.authenticate(request);
            }
            catch (AuthenticationException e) {
                if (e.getMessage() != null) {
                    messages.add(e.getMessage());
                }
                e.getAuthenticateHeader().ifPresent(authenticateHeaders::add);
                continue;
            }
            nextFilter.doFilter(AuthenticationFilter.withPrincipal(request, principal), (ServletResponse)response);
            return;
        }
        AuthenticationFilter.skipRequestBody(request);
        for (String value : authenticateHeaders) {
            response.addHeader("WWW-Authenticate", value);
        }
        if (messages.isEmpty()) {
            messages.add("Unauthorized");
        }
        String error = Joiner.on((String)" | ").join(messages);
        response.setStatus(401, error);
        response.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
        try (PrintWriter writer = response.getWriter();){
            writer.write(error);
        }
    }

    private boolean doesRequestSupportAuthentication(HttpServletRequest request) {
        if (this.authenticators.isEmpty()) {
            return false;
        }
        if (request.isSecure()) {
            return true;
        }
        if (this.allowForwardedHttps) {
            return Strings.nullToEmpty((String)request.getHeader("X-Forwarded-Proto")).equalsIgnoreCase(HTTPS_PROTOCOL);
        }
        return false;
    }

    private static ServletRequest withPrincipal(HttpServletRequest request, final Principal principal) {
        Objects.requireNonNull(principal, "principal is null");
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                return principal;
            }
        };
    }

    private static void skipRequestBody(HttpServletRequest request) throws IOException {
        try (ServletInputStream inputStream = request.getInputStream();){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)ByteStreams.nullOutputStream());
        }
    }
}

