/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.http.server.AsyncResponseHandler;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.TimeStat;
import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.dispatcher.DispatchExecutor;
import com.facebook.presto.dispatcher.DispatchInfo;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.ExecutionFailureInfo;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.HttpRequestSessionContext;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.protocol.ExecutingQueryResponseProvider;
import com.facebook.presto.server.protocol.QueryBlockingRateLimiter;
import com.facebook.presto.server.protocol.QueryResourceUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.tracing.TracerProviderManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Path(value="/")
@RolesAllowed(value={"user"})
public class QueuedStatementResource {
    private static final Logger log = Logger.get(QueuedStatementResource.class);
    private static final Duration MAX_WAIT_TIME = new Duration(1.0, TimeUnit.SECONDS);
    private static final DataSize TARGET_RESULT_SIZE = new DataSize(1.0, DataSize.Unit.MEGABYTE);
    private static final Ordering<Comparable<Duration>> WAIT_ORDERING = Ordering.natural().nullsLast();
    private final DispatchManager dispatchManager;
    private final ExecutingQueryResponseProvider executingQueryResponseProvider;
    private final Executor responseExecutor;
    private final ScheduledExecutorService timeoutExecutor;
    private final Map<QueryId, Query> queries = new ConcurrentHashMap<QueryId, Query>();
    private final Map<QueryId, Query> retriedQueries = new ConcurrentHashMap<QueryId, Query>();
    private final ScheduledExecutorService queryPurger = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"dispatch-query-purger"));
    private final boolean compressionEnabled;
    private final boolean nestedDataSerializationEnabled;
    private final SqlParserOptions sqlParserOptions;
    private final TracerProviderManager tracerProviderManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final QueryBlockingRateLimiter queryRateLimiter;

    @Inject
    public QueuedStatementResource(DispatchManager dispatchManager, DispatchExecutor executor, ExecutingQueryResponseProvider executingQueryResponseProvider, SqlParserOptions sqlParserOptions, ServerConfig serverConfig, TracerProviderManager tracerProviderManager, SessionPropertyManager sessionPropertyManager, QueryBlockingRateLimiter queryRateLimiter) {
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.executingQueryResponseProvider = Objects.requireNonNull(executingQueryResponseProvider, "executingQueryResponseProvider is null");
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
        this.compressionEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isQueryResultsCompressionEnabled();
        this.nestedDataSerializationEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isNestedDataSerializationEnabled();
        this.responseExecutor = Objects.requireNonNull(executor, "responseExecutor is null").getExecutor();
        this.timeoutExecutor = Objects.requireNonNull(executor, "timeoutExecutor is null").getScheduledExecutor();
        this.tracerProviderManager = Objects.requireNonNull(tracerProviderManager, "tracerProviderManager is null");
        this.sessionPropertyManager = sessionPropertyManager;
        this.queryRateLimiter = Objects.requireNonNull(queryRateLimiter, "queryRateLimiter is null");
        this.queryPurger.scheduleWithFixedDelay(() -> {
            try {
                this.purgeQueries(this.queries);
                this.purgeQueries(this.retriedQueries);
            }
            catch (Throwable e) {
                log.error(e, "Error removing old queries");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @Managed
    @Nested
    public TimeStat getRateLimiterBlockTime() {
        return this.queryRateLimiter.getRateLimiterBlockTime();
    }

    @PreDestroy
    public void stop() {
        this.queryPurger.shutdownNow();
    }

    @POST
    @Path(value="/v1/statement")
    @Produces(value={"application/json"})
    public Response postStatement(String statement, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context HttpServletRequest servletRequest, @Context UriInfo uriInfo) {
        if (Strings.isNullOrEmpty((String)statement)) {
            throw QueuedStatementResource.badRequest(Response.Status.BAD_REQUEST, "SQL statement is empty");
        }
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        HttpRequestSessionContext sessionContext = new HttpRequestSessionContext(servletRequest, this.sqlParserOptions, this.tracerProviderManager.getTracerProvider(), Optional.of(this.sessionPropertyManager));
        Query query = new Query(statement, sessionContext, this.dispatchManager, this.executingQueryResponseProvider, 0);
        this.queries.put(query.getQueryId(), query);
        return QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)query.getInitialQueryResults(uriInfo, xForwardedProto, xPrestoPrefixUrl, binaryResults)), this.compressionEnabled).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/v1/statement/queued/retry/{queryId}")
    @Produces(value={"application/json"})
    public Response retryFailedQuery(@PathParam(value="queryId") QueryId queryId, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context UriInfo uriInfo) {
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        Query failedQuery = this.queries.get(queryId);
        if (failedQuery == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.RETRY_QUERY_NOT_FOUND, "failed to find the query to retry with ID " + queryId);
        }
        int retryCount = failedQuery.getRetryCount() + 1;
        Query query = new Query("-- retry query " + queryId + "; attempt: " + retryCount + "\n" + failedQuery.getQuery(), failedQuery.getSessionContext(), this.dispatchManager, this.executingQueryResponseProvider, retryCount);
        this.retriedQueries.putIfAbsent(queryId, query);
        Query query2 = this.retriedQueries.get(queryId);
        synchronized (query2) {
            if (this.retriedQueries.get(queryId).getQueryId().equals((Object)query.getQueryId())) {
                this.queries.put(query.getQueryId(), query);
            } else {
                query = this.retriedQueries.get(queryId);
            }
        }
        return QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)query.getInitialQueryResults(uriInfo, xForwardedProto, xPrestoPrefixUrl, binaryResults)), this.compressionEnabled).build();
    }

    @GET
    @Path(value="/v1/statement/queued/{queryId}/{token}")
    @Produces(value={"application/json"})
    public void getStatus(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug, @QueryParam(value="maxWait") Duration maxWait, @DefaultValue(value="false") @QueryParam(value="binaryResults") boolean binaryResults, @HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @HeaderParam(value="X-Presto-Prefix-Url") String xPrestoPrefixUrl, @Context UriInfo uriInfo, @Suspended AsyncResponse asyncResponse) {
        QueryResourceUtil.abortIfPrefixUrlInvalid(xPrestoPrefixUrl);
        Query query = this.getQuery(queryId, slug);
        ListenableFuture<Double> acquirePermitAsync = this.queryRateLimiter.acquire(queryId);
        ListenableFuture waitForDispatchedAsync = Futures.transformAsync(acquirePermitAsync, acquirePermitTimeSeconds -> {
            this.queryRateLimiter.addRateLimiterBlockTime(new Duration(acquirePermitTimeSeconds.doubleValue(), TimeUnit.SECONDS));
            return query.waitForDispatched();
        }, (Executor)this.responseExecutor);
        ListenableFuture futureStateChange = MoreFutures.addTimeout((ListenableFuture)waitForDispatchedAsync, () -> null, (Duration)((Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait)), (ScheduledExecutorService)this.timeoutExecutor);
        ListenableFuture queryResultsFuture = Futures.transformAsync((ListenableFuture)futureStateChange, ignored -> query.toResponse(token, uriInfo, xForwardedProto, xPrestoPrefixUrl, (Duration)WAIT_ORDERING.min((Object)MAX_WAIT_TIME, (Object)maxWait), this.compressionEnabled, this.nestedDataSerializationEnabled, binaryResults), (Executor)this.responseExecutor);
        AsyncResponseHandler.bindAsyncResponse((AsyncResponse)asyncResponse, (ListenableFuture)queryResultsFuture, (Executor)this.responseExecutor);
    }

    @DELETE
    @Path(value="/v1/statement/queued/{queryId}/{token}")
    @Produces(value={"application/json"})
    public Response cancelQuery(@PathParam(value="queryId") QueryId queryId, @PathParam(value="token") long token, @QueryParam(value="slug") String slug) {
        this.getQuery(queryId, slug).cancel();
        return Response.noContent().build();
    }

    private Query getQuery(QueryId queryId, String slug) {
        Query query = this.queries.get(queryId);
        if (query == null || !query.getSlug().equals(slug)) {
            throw QueuedStatementResource.badRequest(Response.Status.NOT_FOUND, "Query not found");
        }
        return query;
    }

    private void purgeQueries(Map<QueryId, Query> queries) {
        for (Map.Entry entry : ImmutableSet.copyOf(queries.entrySet())) {
            if (!((Query)entry.getValue()).isSubmissionFinished() || this.dispatchManager.isQueryPresent((QueryId)entry.getKey())) continue;
            queries.remove(entry.getKey());
        }
    }

    private static WebApplicationException badRequest(Response.Status status, String message) {
        throw new WebApplicationException(Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }

    private static Response.ResponseBuilder withCompressionConfiguration(Response.ResponseBuilder builder, boolean compressionEnabled) {
        if (!compressionEnabled) {
            builder.encoding("identity");
        }
        return builder;
    }

    private static final class Query {
        private final String query;
        private final SessionContext sessionContext;
        private final DispatchManager dispatchManager;
        private final ExecutingQueryResponseProvider executingQueryResponseProvider;
        private final QueryId queryId;
        private final String slug = "x" + UUID.randomUUID().toString().toLowerCase(Locale.ENGLISH).replace("-", "");
        private final AtomicLong lastToken = new AtomicLong();
        private final int retryCount;
        @GuardedBy(value="this")
        private ListenableFuture<?> querySubmissionFuture;

        public Query(String query, SessionContext sessionContext, DispatchManager dispatchManager, ExecutingQueryResponseProvider executingQueryResponseProvider, int retryCount) {
            this.query = Objects.requireNonNull(query, "query is null");
            this.sessionContext = Objects.requireNonNull(sessionContext, "sessionContext is null");
            this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
            this.executingQueryResponseProvider = Objects.requireNonNull(executingQueryResponseProvider, "executingQueryResponseProvider is null");
            this.queryId = dispatchManager.createQueryId();
            this.retryCount = retryCount;
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public String getQuery() {
            return this.query;
        }

        public SessionContext getSessionContext() {
            return this.sessionContext;
        }

        public String getSlug() {
            return this.slug;
        }

        public long getLastToken() {
            return this.lastToken.get();
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public synchronized boolean isSubmissionFinished() {
            return this.querySubmissionFuture != null && this.querySubmissionFuture.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListenableFuture<?> waitForDispatched() {
            Query query = this;
            synchronized (query) {
                if (this.querySubmissionFuture == null) {
                    this.querySubmissionFuture = this.dispatchManager.createQuery(this.queryId, this.slug, this.retryCount, this.sessionContext, this.query);
                }
                if (!this.querySubmissionFuture.isDone()) {
                    return this.querySubmissionFuture;
                }
            }
            return this.dispatchManager.waitForDispatched(this.queryId);
        }

        public synchronized QueryResults getInitialQueryResults(UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, boolean binaryResults) {
            Verify.verify((this.lastToken.get() == 0L ? 1 : 0) != 0);
            Verify.verify((this.querySubmissionFuture == null ? 1 : 0) != 0);
            return this.createQueryResults(1L, uriInfo, xForwardedProto, xPrestoPrefixUrl, DispatchInfo.waitingForPrerequisites(QueryResourceUtil.NO_DURATION, QueryResourceUtil.NO_DURATION), binaryResults);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenableFuture<Response> toResponse(long token, UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, Duration maxWait, boolean compressionEnabled, boolean nestedDataSerializationEnabled, boolean binaryResults) {
            Optional<ListenableFuture<Response>> executingQueryResponse;
            long lastToken = this.lastToken.get();
            if (token != lastToken && token != lastToken + 1L) {
                throw new WebApplicationException(Response.Status.GONE);
            }
            this.lastToken.compareAndSet(lastToken, token);
            Query query = this;
            synchronized (query) {
                if (this.querySubmissionFuture == null || !this.querySubmissionFuture.isDone()) {
                    QueryResults queryResults = this.createQueryResults(token + 1L, uriInfo, xForwardedProto, xPrestoPrefixUrl, DispatchInfo.waitingForPrerequisites(QueryResourceUtil.NO_DURATION, QueryResourceUtil.NO_DURATION), binaryResults);
                    return Futures.immediateFuture((Object)QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)queryResults), compressionEnabled).build());
                }
            }
            Optional<DispatchInfo> dispatchInfo = this.dispatchManager.getDispatchInfo(this.queryId);
            if (!dispatchInfo.isPresent()) {
                return Futures.immediateFailedFuture((Throwable)new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build()));
            }
            if (this.waitForDispatched().isDone() && (executingQueryResponse = this.executingQueryResponseProvider.waitForExecutingResponse(this.queryId, this.slug, dispatchInfo.get(), uriInfo, xPrestoPrefixUrl, QueryResourceUtil.getScheme(xForwardedProto, uriInfo), maxWait, TARGET_RESULT_SIZE, compressionEnabled, nestedDataSerializationEnabled, binaryResults)).isPresent()) {
                return executingQueryResponse.get();
            }
            return Futures.immediateFuture((Object)QueuedStatementResource.withCompressionConfiguration(Response.ok((Object)this.createQueryResults(token + 1L, uriInfo, xForwardedProto, xPrestoPrefixUrl, dispatchInfo.get(), binaryResults)), compressionEnabled).build());
        }

        public synchronized void cancel() {
            this.querySubmissionFuture.addListener(() -> this.dispatchManager.cancelQuery(this.queryId), MoreExecutors.directExecutor());
        }

        private QueryResults createQueryResults(long token, UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, DispatchInfo dispatchInfo, boolean binaryResults) {
            URI nextUri = this.getNextUri(token, uriInfo, xForwardedProto, xPrestoPrefixUrl, dispatchInfo, binaryResults);
            Optional<QueryError> queryError = dispatchInfo.getFailureInfo().map(this::toQueryError);
            return QueryResourceUtil.createQueuedQueryResults(this.queryId, nextUri, queryError, uriInfo, xForwardedProto, xPrestoPrefixUrl, dispatchInfo.getElapsedTime(), dispatchInfo.getQueuedTime(), dispatchInfo.getWaitingForPrerequisitesTime());
        }

        private URI getNextUri(long token, UriInfo uriInfo, String xForwardedProto, String xPrestoPrefixUrl, DispatchInfo dispatchInfo, boolean binaryResults) {
            if (dispatchInfo.getFailureInfo().isPresent()) {
                return null;
            }
            return QueryResourceUtil.getQueuedUri(this.queryId, this.slug, token, uriInfo, xForwardedProto, xPrestoPrefixUrl, binaryResults);
        }

        private QueryError toQueryError(ExecutionFailureInfo executionFailureInfo) {
            ErrorCode errorCode;
            if (executionFailureInfo.getErrorCode() != null) {
                errorCode = executionFailureInfo.getErrorCode();
            } else {
                errorCode = StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode();
                log.warn("Failed query %s has no error code", new Object[]{this.queryId});
            }
            return new QueryError((String)MoreObjects.firstNonNull((Object)executionFailureInfo.getMessage(), (Object)"Internal error"), null, errorCode.getCode(), errorCode.getName(), errorCode.getType().toString(), errorCode.isRetriable(), executionFailureInfo.getErrorLocation(), executionFailureInfo.toFailureInfo());
        }
    }
}

