/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.resolver.ArtifactResolver;
import java.io.File;
import java.util.List;
import javax.validation.constraints.NotNull;

public class PluginManagerConfig {
    private File installedPluginsDir = new File("plugin");
    private List<String> plugins;
    private File pluginConfigurationDir = new File("etc/");
    private String mavenLocalRepository = ArtifactResolver.USER_LOCAL_REPO;
    private List<String> mavenRemoteRepository = ImmutableList.of((Object)"http://repo1.maven.org/maven2/");
    private ImmutableSet<String> disabledConnectors = ImmutableSet.of();

    public File getInstalledPluginsDir() {
        return this.installedPluginsDir;
    }

    @Config(value="plugin.dir")
    public PluginManagerConfig setInstalledPluginsDir(File installedPluginsDir) {
        this.installedPluginsDir = installedPluginsDir;
        return this;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public PluginManagerConfig setPlugins(List<String> plugins) {
        this.plugins = plugins;
        return this;
    }

    @Config(value="plugin.bundles")
    public PluginManagerConfig setPlugins(String plugins) {
        this.plugins = plugins == null ? null : ImmutableList.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)plugins));
        return this;
    }

    @NotNull
    public String getMavenLocalRepository() {
        return this.mavenLocalRepository;
    }

    @Config(value="maven.repo.local")
    public PluginManagerConfig setMavenLocalRepository(String mavenLocalRepository) {
        this.mavenLocalRepository = mavenLocalRepository;
        return this;
    }

    @NotNull
    public List<String> getMavenRemoteRepository() {
        return this.mavenRemoteRepository;
    }

    public PluginManagerConfig setMavenRemoteRepository(List<String> mavenRemoteRepository) {
        this.mavenRemoteRepository = mavenRemoteRepository;
        return this;
    }

    @Config(value="maven.repo.remote")
    public PluginManagerConfig setMavenRemoteRepository(String mavenRemoteRepository) {
        this.mavenRemoteRepository = ImmutableList.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)mavenRemoteRepository));
        return this;
    }

    @NotNull
    public ImmutableSet<String> getDisabledConnectors() {
        return this.disabledConnectors;
    }

    @Config(value="plugin.disabled-connectors")
    @ConfigDescription(value="Disabled connectors are not registered by PluginManager")
    public PluginManagerConfig setDisabledConnectors(String disabledConnectors) {
        this.disabledConnectors = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)disabledConnectors));
        return this;
    }
}

