/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.execution.ClusterSizeMonitor;
import com.facebook.presto.server.NodeResourceStatusProvider;
import com.facebook.presto.server.ServerConfig;
import java.util.Objects;
import javax.inject.Inject;

public class NodeResourceStatus
implements NodeResourceStatusProvider {
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final boolean isResourceManagerEnabled;

    @Inject
    public NodeResourceStatus(ClusterSizeMonitor clusterSizeMonitor, ServerConfig serverConfig) {
        this.clusterSizeMonitor = clusterSizeMonitor;
        this.isResourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
    }

    @Override
    public boolean hasResources() {
        return (!this.isResourceManagerEnabled || this.clusterSizeMonitor.hasRequiredResourceManagers()) && this.clusterSizeMonitor.hasRequiredCoordinators() && this.clusterSizeMonitor.hasRequiredWorkers();
    }
}

