/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.dispatcher.DispatchManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroupManager;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.metadata.InternalNode;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.resourcemanager.ResourceManagerProxy;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ClusterTtlProviderManager;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1/cluster")
@RolesAllowed(value={"admin", "user"})
public class ClusterStatsResource {
    private final InternalNodeManager nodeManager;
    private final DispatchManager dispatchManager;
    private final boolean isIncludeCoordinator;
    private final boolean resourceManagerEnabled;
    private final ClusterMemoryManager clusterMemoryManager;
    private final Optional<ResourceManagerProxy> proxyHelper;
    private final InternalResourceGroupManager internalResourceGroupManager;
    private final ClusterTtlProviderManager clusterTtlProviderManager;
    private final Supplier<ClusterStats> clusterStatsSupplier;

    @Inject
    public ClusterStatsResource(NodeSchedulerConfig nodeSchedulerConfig, ServerConfig serverConfig, InternalNodeManager nodeManager, DispatchManager dispatchManager, ClusterMemoryManager clusterMemoryManager, Optional<ResourceManagerProxy> proxyHelper, InternalResourceGroupManager internalResourceGroupManager, ClusterTtlProviderManager clusterTtlProviderManager) {
        this.isIncludeCoordinator = Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator();
        this.resourceManagerEnabled = Objects.requireNonNull(serverConfig, "serverConfig is null").isResourceManagerEnabled();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.clusterMemoryManager = Objects.requireNonNull(clusterMemoryManager, "clusterMemoryManager is null");
        this.proxyHelper = Objects.requireNonNull(proxyHelper, "internalNodeManager is null");
        this.internalResourceGroupManager = Objects.requireNonNull(internalResourceGroupManager, "internalResourceGroupManager is null");
        this.clusterTtlProviderManager = Objects.requireNonNull(clusterTtlProviderManager, "clusterTtlProvider is null");
        Duration expirationDuration = Objects.requireNonNull(serverConfig, "serverConfig is null").getClusterStatsExpirationDuration();
        this.clusterStatsSupplier = expirationDuration.getValue() > 0.0 ? Suppliers.memoizeWithExpiration(this::calculateClusterStats, (long)expirationDuration.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS) : this::calculateClusterStats;
    }

    @GET
    @Produces(value={"application/json", "application/x-thrift+binary", "application/x-thrift+compact", "application/x-thrift+fb_compact"})
    public void getClusterStats(@HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo, @Context HttpServletRequest servletRequest, @Suspended AsyncResponse asyncResponse, @QueryParam(value="includeLocalInfoOnly") @DefaultValue(value="false") boolean includeLocalInfoOnly) {
        if (this.resourceManagerEnabled && !includeLocalInfoOnly) {
            this.proxyClusterStats(servletRequest, asyncResponse, xForwardedProto, uriInfo);
            return;
        }
        asyncResponse.resume((Object)Response.ok((Object)this.clusterStatsSupplier.get()).build());
    }

    private ClusterStats calculateClusterStats() {
        long runningQueries = 0L;
        long blockedQueries = 0L;
        long queuedQueries = 0L;
        long activeNodes = this.nodeManager.getNodes(NodeState.ACTIVE).size();
        if (!this.isIncludeCoordinator) {
            --activeNodes;
        }
        long runningDrivers = 0L;
        long runningTasks = 0L;
        double memoryReservation = 0.0;
        long totalInputRows = this.dispatchManager.getStats().getConsumedInputRows().getTotalCount();
        long totalInputBytes = this.dispatchManager.getStats().getConsumedInputBytes().getTotalCount();
        long totalCpuTimeSecs = this.dispatchManager.getStats().getConsumedCpuTimeSecs().getTotalCount();
        for (BasicQueryInfo query : this.dispatchManager.getQueries()) {
            if (query.getState() == QueryState.QUEUED) {
                ++queuedQueries;
            } else if (query.getState() == QueryState.RUNNING) {
                if (query.getQueryStats().isFullyBlocked()) {
                    ++blockedQueries;
                } else {
                    ++runningQueries;
                }
            }
            if (query.getState().isDone()) continue;
            totalInputBytes += query.getQueryStats().getRawInputDataSize().toBytes();
            totalInputRows += query.getQueryStats().getRawInputPositions();
            totalCpuTimeSecs = (long)((double)totalCpuTimeSecs + query.getQueryStats().getTotalCpuTime().getValue(TimeUnit.SECONDS));
            memoryReservation += (double)query.getQueryStats().getUserMemoryReservation().toBytes();
            runningDrivers += (long)query.getQueryStats().getRunningDrivers();
            runningTasks += (long)query.getQueryStats().getRunningTasks();
        }
        return new ClusterStats(runningQueries, blockedQueries, queuedQueries, activeNodes, runningDrivers, runningTasks, memoryReservation, totalInputRows, totalInputBytes, totalCpuTimeSecs, this.internalResourceGroupManager.getQueriesQueuedOnInternal());
    }

    @GET
    @Path(value="memory")
    public Response getClusterMemoryPoolInfo(@HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo) {
        return Response.ok().entity(this.clusterMemoryManager.getMemoryPoolInfo()).build();
    }

    @GET
    @Path(value="workerMemory")
    public Response getWorkerMemoryInfo(@HeaderParam(value="X-Forwarded-Proto") String xForwardedProto, @Context UriInfo uriInfo) {
        return Response.ok().entity(this.clusterMemoryManager.getWorkerMemoryInfo()).build();
    }

    @GET
    @Path(value="ttl")
    public Response getClusterTtl() {
        return Response.ok().entity((Object)this.clusterTtlProviderManager.getClusterTtl()).build();
    }

    private void proxyClusterStats(HttpServletRequest servletRequest, AsyncResponse asyncResponse, String xForwardedProto, UriInfo uriInfo) {
        try {
            Preconditions.checkState((boolean)this.proxyHelper.isPresent());
            Iterator<InternalNode> resourceManagers = this.nodeManager.getResourceManagers().iterator();
            if (!resourceManagers.hasNext()) {
                asyncResponse.resume((Object)Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build());
                return;
            }
            InternalNode resourceManagerNode = resourceManagers.next();
            URI uri = uriInfo.getRequestUriBuilder().scheme(resourceManagerNode.getInternalUri().getScheme()).host(resourceManagerNode.getHostAndPort().toInetAddress().getHostName()).port(resourceManagerNode.getInternalUri().getPort()).build(new Object[0]);
            this.proxyHelper.get().performRequest(servletRequest, asyncResponse, uri);
        }
        catch (Exception e) {
            asyncResponse.resume((Throwable)e);
        }
    }

    @ThriftStruct
    public static class ClusterStats {
        private final long runningQueries;
        private final long blockedQueries;
        private final long queuedQueries;
        private final long activeWorkers;
        private final long runningDrivers;
        private final long runningTasks;
        private final double reservedMemory;
        private final long totalInputRows;
        private final long totalInputBytes;
        private final long totalCpuTimeSecs;
        private final long adjustedQueueSize;

        @JsonCreator
        @ThriftConstructor
        public ClusterStats(@JsonProperty(value="runningQueries") long runningQueries, @JsonProperty(value="blockedQueries") long blockedQueries, @JsonProperty(value="queuedQueries") long queuedQueries, @JsonProperty(value="activeWorkers") long activeWorkers, @JsonProperty(value="runningDrivers") long runningDrivers, @JsonProperty(value="runningTasks") long runningTasks, @JsonProperty(value="reservedMemory") double reservedMemory, @JsonProperty(value="totalInputRows") long totalInputRows, @JsonProperty(value="totalInputBytes") long totalInputBytes, @JsonProperty(value="totalCpuTimeSecs") long totalCpuTimeSecs, @JsonProperty(value="adjustedQueueSize") long adjustedQueueSize) {
            this.runningQueries = runningQueries;
            this.blockedQueries = blockedQueries;
            this.queuedQueries = queuedQueries;
            this.activeWorkers = activeWorkers;
            this.runningDrivers = runningDrivers;
            this.runningTasks = runningTasks;
            this.reservedMemory = reservedMemory;
            this.totalInputRows = totalInputRows;
            this.totalInputBytes = totalInputBytes;
            this.totalCpuTimeSecs = totalCpuTimeSecs;
            this.adjustedQueueSize = adjustedQueueSize;
        }

        @JsonProperty
        @ThriftField(value=1)
        public long getRunningQueries() {
            return this.runningQueries;
        }

        @JsonProperty
        @ThriftField(value=2)
        public long getBlockedQueries() {
            return this.blockedQueries;
        }

        @JsonProperty
        @ThriftField(value=3)
        public long getQueuedQueries() {
            return this.queuedQueries;
        }

        @JsonProperty
        @ThriftField(value=4)
        public long getActiveWorkers() {
            return this.activeWorkers;
        }

        @JsonProperty
        @ThriftField(value=5)
        public long getRunningDrivers() {
            return this.runningDrivers;
        }

        @JsonProperty
        @ThriftField(value=6)
        public long getRunningTasks() {
            return this.runningTasks;
        }

        @JsonProperty
        @ThriftField(value=7)
        public double getReservedMemory() {
            return this.reservedMemory;
        }

        @JsonProperty
        @ThriftField(value=8)
        public long getTotalInputRows() {
            return this.totalInputRows;
        }

        @JsonProperty
        @ThriftField(value=9)
        public long getTotalInputBytes() {
            return this.totalInputBytes;
        }

        @JsonProperty
        @ThriftField(value=10)
        public long getTotalCpuTimeSecs() {
            return this.totalCpuTimeSecs;
        }

        @JsonProperty
        @ThriftField(value=11)
        public long getAdjustedQueueSize() {
            return this.adjustedQueueSize;
        }
    }
}

