/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class AsyncPageTransportForwardFilter
implements Filter {
    private static final String GET_RESULTS_URL_PREFIX = "/v1/task";
    private static final Pattern GET_RESULTS_URL_PATTERN = Pattern.compile("/v1/task/[^/]+/results/[^/]+/[^/]+/?");
    private static final String GET_RESULTS_METHOD = "GET";
    private static final String GET_RESULTS_URL_FORWARD_PREFIX = "/v1/task/async";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestUri = httpRequest.getRequestURI();
        if (this.isGetResultsRequest(httpRequest.getRequestURI(), httpRequest.getMethod())) {
            String forwardUri = GET_RESULTS_URL_FORWARD_PREFIX + requestUri.substring(GET_RESULTS_URL_PREFIX.length());
            httpRequest.getRequestDispatcher(forwardUri).forward(request, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isGetResultsRequest(String uri, String method) {
        if (!GET_RESULTS_METHOD.equals(method)) {
            return false;
        }
        if (!uri.startsWith(GET_RESULTS_URL_PREFIX)) {
            return false;
        }
        return GET_RESULTS_URL_PATTERN.matcher(uri).matches();
    }

    public void destroy() {
    }
}

