/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.spi.function.RankingWindowFunction;
import com.facebook.presto.spi.function.WindowFunctionSignature;

@WindowFunctionSignature(name="cume_dist", returnType="double")
public class CumulativeDistributionFunction
extends RankingWindowFunction {
    private long totalCount;
    private long count;

    public void reset() {
        this.totalCount = this.windowIndex.size();
        this.count = 0L;
    }

    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount, int currentPosition) {
        if (newPeerGroup) {
            this.count += (long)peerGroupCount;
        }
        DoubleType.DOUBLE.writeDouble(output, (double)this.count / (double)this.totalCount);
    }
}

