/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Optional;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.CompactSketch;

public class ThetaSketchFunctions {
    private static final RowType SUMMARY_TYPE = RowType.from((List)ImmutableList.of((Object)new RowType.Field(Optional.of("estimate"), (Type)DoubleType.DOUBLE), (Object)new RowType.Field(Optional.of("theta"), (Type)DoubleType.DOUBLE), (Object)new RowType.Field(Optional.of("upper_bound_std"), (Type)DoubleType.DOUBLE), (Object)new RowType.Field(Optional.of("lower_bound_std"), (Type)DoubleType.DOUBLE), (Object)new RowType.Field(Optional.of("retained_entries"), (Type)IntegerType.INTEGER)));

    private ThetaSketchFunctions() {
    }

    @ScalarFunction(value="sketch_theta_estimate")
    @Description(value="Get the estimate of unique values from a theta sketch")
    @SqlType(value="double")
    public static double thetaSketchEstimate(@SqlType(value="varbinary") Slice input) {
        CompactSketch sketch = CompactSketch.wrap((Memory)Memory.wrap((ByteBuffer)input.toByteBuffer(), (ByteOrder)ByteOrder.nativeOrder()));
        return sketch.getEstimate();
    }

    @ScalarFunction(value="sketch_theta_summary")
    @Description(value="parses a brief summary from a theta sketch")
    @SqlType(value="row(estimate double, theta double, upper_bound_std double, lower_bound_std double, retained_entries int)")
    public static Block thetaSketchSummary(@SqlType(value="varbinary") Slice input) {
        CompactSketch sketch = CompactSketch.wrap((Memory)Memory.wrap((ByteBuffer)input.toByteBuffer(), (ByteOrder)ByteOrder.nativeOrder()));
        BlockBuilder output = SUMMARY_TYPE.createBlockBuilder(null, 1);
        BlockBuilder row = output.beginBlockEntry();
        DoubleType.DOUBLE.writeDouble(row, sketch.getEstimate());
        DoubleType.DOUBLE.writeDouble(row, sketch.getTheta());
        DoubleType.DOUBLE.writeDouble(row, sketch.getUpperBound(1));
        DoubleType.DOUBLE.writeDouble(row, sketch.getLowerBound(1));
        IntegerType.INTEGER.writeLong(row, (long)sketch.getRetainedEntries());
        output.closeEntry();
        return output.build().getBlock(0);
    }
}

